/* 
 * i550open.c - open the i550 wiht i550conn and i550sbuf
 * 
 * Author:	Ralph E. Droms/Thomas Narten
 * 		Dept. of Computer Sciences
 * 		Purdue University
 * Date:	Wed Sep 26 1984
 * Copyright (c) 1984 Ralph E. Droms
 */

#include <i550.h>
#include <kernel.h>
#include <conf.h>
#include <mark.h>

extern int i550input();

struct  ip_ether {		/* used at boot time to find IP address	*/
	char *sbname,		/* of machine				*/
             ip_addr[4],
	     e_addr[6];
} ;
static struct ip_ether ip_ether[] =
    { { "cinnamon", { 192, 5, 48, 10 },{ 0x0, 0xaa, 0x0, 0x0, 0x1a, 0x72}} ,
      { "clove",    { 192, 5, 48, 11 },{ 0x0, 0xaa, 0x0, 0x0, 0x7, 0x4a }} ,
      { "cumin",    { 192, 5, 48, 12 },{ 0x0, 0xaa, 0x0, 0x0, 0x0, 0xc5} },
      { "ginger",   { 192, 5, 48, 13 },{ 0, 0xaa, 0, 0, 0, 0xc1} },
      { "nutmeg",   { 192, 5, 48, 14 },{ 0, 0xaa, 0, 0, 0x1a, 0x07 } }
    };


i550open(){


	register struct i550dev *dd;
	register struct edl_sbuf *esb;
	int i;


/*
 * If already open or 550 doesn't exist, error.
 * If it was open but is now closed, just re-open.
 */

	if (!i550.exists || NSBUF <= 0) {
		return(SYSERR);
	}
	dd = &i550.dev;
	if (dd->d_open++)
	    return(OK);			/* already opened once	 */
/* 
 * Initialize queue of packets that have arrived but have not yet been
 * read by upper level user processes
 */
	i550.hd_sbuf = i550.tl_sbuf = 0;
	for (i = 0; i < NSBUF; i++)
	    i550.rgpsbuf[i] = (struct edl_sbuf *) NULL;


	inton(PICMASK, I550INTR);		/* Enable I550 interrupts */

/*
 * Connect to the default data-link type code and supply the buffers.
 * Use the later part of the "supply-buf" array.
 */

	if (!control(ETHER, EDL_CONNECT, ETHER_IPTYPE))	/* accept IP packets*/
		return(SYSERR);
	if (!control(ETHER, EDL_CONNECT, ETHER_ARPTYPE))/* ''      ARP '' */
		return(SYSERR);
	if (!control(ETHER, EDL_ADDMCID, bcast))	/* '' broadcast '' */
		return(SYSERR);
/* 
 * determine what out ethernet address is.
 */
	if (!control(ETHER, EDL_READ, i550.et_addr, EDLO_HOST_ADDRESS))
	return(SYSERR);

	if ((i = mpeth_ip(i550.et_addr)) >= 0) {
	    bcopy(ip_ether[i].ip_addr, i550.ip_addr, 6);
	    bcopy(ip_ether[i].sbname, i550.sbname, MAX_HOST_NAME);
	    i550.sbname[MAX_HOST_NAME-1] = '\0';
	    kprintf("Welcome to purdue-%s.\n", i550.sbname);
	} else {
	    kprintf("Don't know my IP address.\n");
	    return(SYSERR);
	}

	for(i=NSBUF,esb = &dd->d_sBuf[0];--i; ++esb) {
		if (!control(ETHER, EDL_SUPPLYBUF, esb)) {		/* bad problem */
			return(SYSERR);
		}
	}
	return(OK);

}
	
    
mpeth_ip(ether)
char *ether;
{
    int i;
    for (i = 0; i < ((sizeof ip_ether) / (sizeof (struct ip_ether))); i++)
        if (compare(ether, ip_ether[i].e_addr)) {
		return(i);
	}
    return(-1);
}
compare(sbeth1, sbeth2)
register char *sbeth1, *sbeth2;
{
    int i;
    for (i = 0; i < ETHER_ADDR_SIZE; i++)
	if (*sbeth1++ != *sbeth2++)
	   return(FALSE);
    return(TRUE);
}
    
