/* 
 * i550intr.c - i550 driver interrupt routine
 * 
 * Author:	Ralph E. Droms/Thomas Narten
 * 		Dept. of Computer Sciences
 * 		Purdue University
 * Date:	Mon Sep 24 1984
 * Copyright (c) 1984 Ralph E. Droms
 */

#include <i550.h>
#include <kernel.h>

/*
 * i550intr
 *	iSBC 550 interrupt handler.
 *
 * This routine is invoked as a result of an interrupt
 * generated by the 550.  It calls i550rframe() to process all frames
 * present in the inbound request queue.
 *
 * Assumes interrupts are disabled on entry.
 */
 
i550intr(level)
int	level;				/* interrupt level: ignored for now */
{
	outbyte(0xc9, 0x0e);		/* turn on LED 3 */
	outbyte(I550PORT, 0x4);		/* turn off the interrupt */
	if (i550.RcvQ.d_empty != MIP_NO_CHANGE) {	/* ie, useful interrupt */
		i550.RcvQ.d_empty = MIP_NO_CHANGE;
		i550rframe();
	}
	outbyte(0xc9, 0x06);		/* Turn off LED 3 */
}

/*
 * i550rframe
 *	550 Receive Frame
 *
 * This routine loops removing entries from the inbound request queue
 * from the 550 until the queue is empty.  For each entry, if it is a
 * response it discards it.  If it is a command it calls i550mxmt to send
 * the response after it has changed the request queue entry to a
 * response.  If it was any other type of message the indication that an
 * error occurred is printed.
 * 
 */

i550rframe()
{
    register struct edl_hdr *eh;
    struct mip_rqe	rqe;

    for(;;) {
	if (!i550mrcv(&rqe))			/* nothing to receive */
	    return;
        switch (UNSIGNED(rqe.r_request)) {
	    case MIP_MSG_DELIVERED_NO_COPY:

	     /*  Response from the i550 saying "I got your command".	*/
	     /*  The i550 has not actually processed the command yet.	*/

		break;

	    case MIP_MSG_DELIVERED_COPY:

	    /* I don't know what this means, it never seems	*/
	    /*  to happen.					*/

		kprintf("i550intr: ..DELIVERED_COPY recieved\n");
		break;

	    case MIP_SEND_COMMAND:

	    /* The I550 has a cammand. This in reality is a	*/
	    /*  response from i550 saying I finally completed	*/
	    /* your request.					*/

	    eh = (struct edl_hdr *)OFFSETOF(rqe.r_dataPtr);
	    rqe.r_request = MIP_MSG_DELIVERED_NO_COPY;
	    rqe.r_sDevId = rqe.r_dDevId;
	    rqe.r_dDevId = I550_DEVICE_ID;
	    if (!i550mxmt(&rqe))
	        kprintf("i550rframe: couldn't ack\n");
	    switch (eh -> eh_command) {
	    case EDL_SUPPLYBUF:

	     if (scount(i550.read_sem) < NSBUF) {
		    i550.rgpsbuf[i550.tl_sbuf++] = (struct edl_sbuf *)
						OFFSETOF(rqe.r_dataPtr);
		    if (i550.tl_sbuf >= NSBUF)
		        i550.tl_sbuf = 0;
		    if (signal(i550.read_sem) == SYSERR)
			kprintf("i550intr: can't signal readsem\n");
		} else
		    kprintf("i550intr: Inconsistent queue state\n");
		break;
	    case EDL_CONNECT:
	    case EDL_DISCONNECT:
	    case EDL_ADDMCID:
	    case EDL_DELETEMCID:
	    case EDL_READ:
	    case EDL_READC:
	    case EDL_TRANSMIT:

		if (resume( eh -> eh_rspSocket )== SYSERR)
			kprintf("i550intr: couldn't resume\n");
		break;

	    default: kprintf("i550intr: unknown command type 0x%0x\n",
		eh-> eh_command);
	    }
	    break;

	    default :
	        kprintf("i550rframe got request=%x\n", UNSIGNED(rqe.r_request));
	}
    }
}
