/*
*	i550input.c : process that reads input off the network, and
*		handles ARP requests. All user processes read
*		from the network by doing precieves from me.
*
*	Author: Thomas Narten
*	date: Nov. 9, 1984
*/
#include <i550.h>
#include <kernel.h>
#include <conf.h>

#define OTHER_PORT_LEN 2


int arp_port,
    other_port,
    sys_ready,
    mutex_arp;
struct arp_reply {
    struct edl_hdr hdr;
    short		exm_length;
    short		exm_extnsn;
    char		exm_idsId;
    char		exm_ext2;
    short		exm_extLength;
    char		exm_dstAddr[ETHER_ADDR_SIZE];
    char		exm_srcAddr[ETHER_ADDR_SIZE];
    short		exm_type;
    struct arp_pkt arp_pkt;
} ;

i550input()
{
    struct edl_sbuf *psbuf;
    struct arp_pkt  *parp;
    struct arp_reply *parp_reply;

    sys_ready = 0;
    if ( (arp_port=pcreate(1)) == SYSERR ||
        (other_port=pcreate(OTHER_PORT_LEN)) == SYSERR ||
	(mutex_arp=screate(1)) == SYSERR)
	kprintf("input: Cannot create ports.\n");

    sys_ready= 0;
    while ( TRUE ) {
	kprintf("arp: reading..\n");
	psbuf = (struct edl_sbuf *) read(ETHER);
	kprintf("arp: read from %x.%x.%x.%x.%x.%x, type %u\n",
	psbuf->esb_srcAddr[0],	psbuf->esb_srcAddr[1],psbuf->esb_srcAddr[2],
	psbuf->esb_srcAddr[3],	psbuf->esb_srcAddr[4],psbuf->esb_srcAddr[5],
	psbuf->esb_type);
	parp = (struct arp_pkt *) psbuf -> esb_message;
	if (psbuf-> esb_type == swapb(ETHER_ARPTYPE) ) {
	    kprintf("arp: got an arp packet\n");
	    if (parp -> arp_op == swapb(ARP_REQUEST)) {
	        kprintf("arp: got an ARP REQUEST\n");
		if (strncmp(i550.ip_addr, parp -> arp_tpa, IP_ADDR_SIZE) == 0) {
		    kprintf("arp: got an ARP request for ME!\n");
		    parp_reply = (struct arp_reply *)
			control(ETHER, GET_XMIT_BUF);
		    kprintf("arp: got buffer %d\n", parp_reply);
		    bcopy(psbuf->esb_srcAddr,parp_reply->exm_dstAddr, ETHER_ADDR_SIZE);
		    bcopy(i550.et_addr,parp_reply->arp_pkt.arp_sha,ETHER_ADDR_SIZE);
		    bcopy(parp->arp_sha, parp_reply->arp_pkt.arp_tha, ETHER_ADDR_SIZE);
		    bcopy(i550.ip_addr, parp_reply->arp_pkt.arp_spa, IP_ADDR_SIZE);
		    bcopy(parp->arp_spa, parp_reply->arp_pkt.arp_tpa, IP_ADDR_SIZE);
		    parp_reply->arp_pkt.arp_op = swapb(ARP_REPLY);
		    parp_reply->arp_pkt.arp_hln = 6;
		    parp_reply->arp_pkt.arp_pln = 4;
		    parp_reply->arp_pkt.arp_hrd = swapb(ARPHRD_ETHER);
		    parp_reply->arp_pkt.arp_pro = swapb(ETHER_IPTYPE);
		    parp_reply->exm_type = swapb(ETHER_ARPTYPE);
		    kprintf("arp: replying to arp request\n");
		    write(ETHER, parp_reply, (sizeof (struct arp_reply)));
		} else {
		   kprintf("arp: Got an ARP request for %x.%x.%x.%x\n",
		   parp->arp_tpa[0],parp->arp_tpa[1],parp->arp_tpa[2],
		   parp->arp_tpa[3]);
		   kprintf("arp: It came from %x.%x.%x.%x.%x.%x.\n",
			psbuf->esb_srcAddr[0],	psbuf->esb_srcAddr[1],
			psbuf->esb_srcAddr[2],	psbuf->esb_srcAddr[3],
			psbuf->esb_srcAddr[4],psbuf->esb_srcAddr[5] );
		}

		control(ETHER, EDL_SUPPLYBUF, psbuf);
	    } else {
		if (pcount(arp_port) == 1)
		    kprintf("arp port full===> funny state\n");
		else {
		    kprintf("arp: depositing ARP REPLY in port.\n");
		    psend(arp_port, psbuf);
		}	
	    }
	} else {
/******
	    if (pcount(other_port) == OTHER_PORT_LEN)
	        control(ETHER, EDL_SUPPLYBUF, psbuf);
	    else
	        psend(other_port, psbuf);
*******/
        control(ETHER, EDL_SUPPLYBUF, psbuf);
	}
    }
}