
/* 
 * i550cntl.c - i550 driver ioctl function
 * 
 * Author:	Ralph E. Droms/Thomas Narten
 * 		Dept. of Computer Sciences
 * 		Purdue University
 * Date:	Mon Sep 24 1984
 * Copyright (c) 1984 Ralph E. Droms
 */

/*
 * $Log:	i550cntl.c,v $
 * Revision 1.2  84/12/11  12:09:56  narten
 * working version, checkpoint for future versions
 * 
 * Revision 1.1  84/10/01  13:50:34  droms
 * Initial revision
 * 
 */

#include <conf.h>
#include <kernel.h>
#include <i550.h>
#include <proc.h>
/*------------------------------------------------------------------------
 *  i550cntl  -  control the i550 controller interface to the ethernet
 *------------------------------------------------------------------------
 */
i550cntl(devptr, func, addr, obj)
struct	devsw	*devptr;
int func;
char *addr;
unsigned obj;
{
    char ps;
    int result;
    unsigned dltc;
 
    switch ( func ) {

      case EDL_CONNECT:
      case EDL_DISCONNECT:
      {
        struct edl_conn *edl;
	dltc = (unsigned) addr;
	edl = (struct edl_conn *)getbuf(i550.xmitpid);	/* get the generic frame */
	if (edl == (struct edl_conn *) SYSERR)
	    kprintf("i550cntl: getbuf returned %x.\n", edl);
        edl -> ec_hdr.eh_rspSocket = currpid;
	edl->ec_hdr.eh_command = func;	/* what to do */
	edl->ec_type = swapb(dltc);		/* data-link type code */
	disable(ps);				/* mutex MIP Q's */
	if (result = i550tframe(edl)){
	    suspend(currpid);
	    result = (edl->ec_hdr.eh_result == 0);	/* TRUE <==> 550 liked it */
	} else
	    kprintf("i550cntl: tframe returned error.\n");
	if (freebuf(edl) == SYSERR)
	    kprintf("i550cntl: couldn't free buffer.\n");
	restore(ps);
      }
      break;

      case EDL_ADDMCID:
      case EDL_DELETEMCID:
        {
	    struct edl_amcid *edl;
	    edl = (struct edl_amcid *)getbuf(i550.xmitpid);	/* get the generic frame */
	    if (edl == (struct edl_amcid *) SYSERR)
		kprintf("i550cntl: getbuf returned %x.\n", edl);
	    edl -> eam_hdr.eh_rspSocket = currpid;
	    edl->eam_hdr.eh_command = func;	/* what to do */
	    bcopy(addr, edl -> eam_mcid, ETHER_ADDR_SIZE);
	    disable(ps);				/* mutex MIP Q's */
	    if (result = i550tframe(edl)){
	        suspend(currpid);
		result = (edl->eam_hdr.eh_result == 0);	/* TRUE <==> 550 liked it */
	    } else
	        kprintf("i550cntl: tframe returned error.\n");
	    if (freebuf(edl) == SYSERR)
		kprintf("i550cntl: couldn't free buffer.\n");
	    restore(ps);
	}
      break;

   case EDL_SUPPLYBUF:


   {
	struct edl_sbuf *edl;
	edl = (struct edl_sbuf *) addr;
	edl->esb_hdr.eh_command = EDL_SUPPLYBUF;	/* what to do with it */
	edl->esb_length = EDL_PACKET_OVHD + MAXPACKET;	/* max size to receive */
	disable(ps);					/* mutex MIP */
	result = i550tframe(edl);
	restore(ps);
   }
    break;
      case EDL_READ:
      case EDL_READC:
        {
	    struct edl_read *edl;
	    edl = (struct edl_read *)getbuf(i550.xmitpid);	/* get the generic frame */
	    if (edl == (struct edl_read *) SYSERR)
		kprintf("i550cntl: getbuf returned %x.\n", edl);
	    edl -> erd_hdr.eh_rspSocket = currpid;
	    edl->erd_hdr.eh_command = func;	/* what to do */
	    edl->erd_dlo = obj;
	    disable(ps);				/* mutex MIP Q's */
	    if (result = i550tframe(edl)){
	        suspend(currpid);
		result = (edl->erd_hdr.eh_result == 0);	/* TRUE <==> 550 liked it */
	    } else
	       kprintf("i550cntl: tframe returned error\n");
	    switch (obj) {
	        case EDLO_HOST_ADDRESS: bcopy(edl->erd_val, addr, 6);
				    break;
		case EDLO_TOTAL_SENT:
		case EDLO_TOTAL_RECEIVED:
				bcopy(edl->erd_val, addr, 4);
				break;
		default:
			addr[0] = edl->erd_val[0];
			addr[1] = edl->erd_val[1];
	    }
	    if (freebuf(edl) == SYSERR)
		kprintf("i550cntl: couldn't free buffer.\n");
	    restore(ps);
	}
      break;

    case GET_XMIT_BUF:
/*		kprintf("control: getting an xmit buffer\n");  */
    
		return(getbuf(i550.xmitpid));

    case FREE_XMIT_BUF :
/*	kprintf("control: returning an xmit buffer\n");		*/

		   return(freebuf(addr));
default:
	 return(SYSERR);
    }
    return(result);
}
