/* dgread.c - dgread */

#include <conf.h>
#include <kernel.h>
#include <i550.h>
#include <udp.h>

/*------------------------------------------------------------------------
 * dgread  --  read a packet from a previously opened UDP device
 *------------------------------------------------------------------------
 */
dgread(devptr, packet, len)
struct	devsw	*devptr;
udp_packet	*packet;
int	len;
{
	struct	udpblk	*udpptr;
	struct	edl_sbuf	*epacket;
	
	if (len <= 0)
		return(SYSERR);
	udpptr = (struct udpblk *) devptr->dvioblk;
	epacket = (struct edl_sbuf *) preceive(udpptr->udp_iport);
	if (epacket->esb_length < len)
		len = epacket->esb_length;
	bcopy(epacket->message, packet, len);
	control(ETHER, EDL_SUPPLYBUF, epacket);
	return(len);
}
