/*
*
*   ctxsw.s
*
*
*   ctxsw -- perform context switch.  Save current process state
*            in old save area set process state form new save area.
*            Call from C with:
*                   ctxsw(oldsav,newsav);
*            where oldsave and newsav are both pointers to at least
*            28 bytes of space (i.e. 14 words).
*
*            upon entry stack looks like
*                   new save area address
*                   old save area address
*                   return address           <- %sp points here
*
*            The saved process state consists of:
*                   flags, %ax, %bx, %cx, %dx, %sp, %bp, %si,
*                   %di, %cs (ignored), %ds, %ss, %es, and %ip
*            This is more than necessary, and can be modified later
*            to optimize performance.
*/
	.data
	.text
/*   define register offsets.  These are offsets into the process
*   table relative to the beginning of the saved register area.
*/
	rfl =  0 
	rax =  2 
	rbx =  4 
	rcx =  6 
	rdx =  8 
	rsp = 10 
	rbp = 12 
	rsi = 14 
	rdi = 16 
	rcs = 18 
	rds = 20 
	rss = 22 
	res = 24 
	rip = 26 
/*
* stack offsets after %di, %bp, and flags are pushed
*/
	sdi    =  0
	sbp    =  2
	sfl    =  4
	sip    =  6
	oldsav =  8
	newsav = 10
/*
* save current state
*/
	.globl _ctxsw
_ctxsw:
	push	di
	push	bp
	pushf		
/*
*		at this point the stack looks like:
*			new save area pointer
*			old save area pointer
*			return address
*			%di of current process
*			%bp of current process
*			flags				<- %sp points here
*
*  Allow indexing into the stack
*/
	mov	bp,sp
	mov	di,*oldsav(bp)	   /*  Move old save pointer into as */
	mov	*rax(di),ax
	pop	ax		   /*  Save flags register */
	mov	*rfl(di),ax
	mov	*rbx(di),bx	   /*  Save registers bx - dx */
	mov	*rcx(di),cx
	mov	*rdx(di),dx
/*  Save BP (base pointer)and si of current process*/
	pop	ax		
	mov	*rbp(di),ax
	mov	*rsi(di),si
/*  restore and save register di of current process*/
	pop	ax		
	mov	*rdi(di),ax
/*
*  Save segement registers. NOTE this does not need to be done
*  in our current configuration, since they always contain 0.
*/
	mov	*rcs(di),cs
	mov	*rds(di),ds
	mov	*rss(di),ss
	mov	*res(di),es
/*
*  Save return address of current process
*/
	pop	ax		
	mov	*rip(di),ax
/*
*  save stack last
*/
	mov	*rsp(di),sp	
/*
* now there are only two things on the stack
*	new save area pointer
*	old save area pointer  <- %sp
*/
	pop	ax
	pop	di
/*
*  restore the state for the process being switched to.
*
*  Restore stack. (thats is SP and si)
*/
	mov	sp,*rsp(di)
	mov	ss,*rss(di)
/*  Push return address back onto the stack	*/
	mov	ax,*rip(di)
	push	ax		
/*  Put flags onto stack			*/
 	mov	ax,*rfl(di)
	push	ax		
/*  Restore registers for process to be switched to */
	mov	es,*res(di)
	mov	ds,*rds(di)
	mov	si,*rsi(di)
	mov	bp,*rbp(di)
	mov	dx,*rdx(di)
	mov	cx,*rcx(di)
	mov	bx,*rbx(di)
	mov	ax,*rax(di)
	mov	di,*rdi(di)
	popf			/*  Restore flags  */
	ret
