	.data
	.text
/*
* 100 millisecond delay between ticks
* on a 153.6 kHZ clock
* (corresponds to a tick rate of 10 Hz)
*/
	CCOUNT=15360
	CT1PORT=0xD2	   /* count value */
/*
* I/O address for loading timer 1's
* count value
*/
	EOI=0x20	   /* end of interupt instruction */
	OCW3=0xC0	   /* PIC port			  */
	.globl	_clkint
	.globl	_defclk
	.globl	_clkdiff
	.globl	_slnempty
	.globl	_sltop
	.globl	_preempt
/*
* ============================================================
* clkint - realtime clock interrupt service routine
* ============================================================
*/
_clkint:
	push	ax	/* save registers that this routine uses	*/
	push	cx
	push	dx
	push	si
	mov	cx,#CCOUNT	/* reload timer one count		*/
	movb	al,cl		/* load LSB first			*/
	out	CT1PORT
	movb	al,ch		/* then load MSB			*/
	out	CT1PORT
	test	_defclk,#0xffff /* are clock ticks deferred?		*/
	je	notdef		/* no => go process this tick		*/
	inc	_clkdiff	/* yes => count in clkdiff		*/
	pop	si		/*        restore registers and return  */
	pop	dx		/*	  quickly			*/
	pop	cx
	pop	ax
	iret
notdef:
	test	_slnempty,#0xffff /* is the sleep queue empty?		*/
	je	clpreem		/* no => go process preemption		*/
	mov	si,_sltop	/* yes => decrement delta key on first  */
	dec	(si)		/* process, calling wakeup if it 	*/
	jg	clpreem		/* reaches 0				*/
	push	ax
	push	dx
	push	si
	call    _wakeup
	pop	si
	pop	dx
	pop	ax
clpreem:
	dec	_preempt	/* decrement preemption counter		*/
	jg	clret		 
	push	ax
	push	dx
	push	si
	call	_resched
	pop	si
	pop	dx
	pop	ax
clret:
	movb	al,#EOI
	out	OCW3
	pop	si
	pop	dx
	pop	cx
	pop	ax
	iret
