/* clkinit.c - clkinit */

#include <conf.h>
#include <kernel.h>
#include <sleep.h>

/*
 *------------------------------------------------------------------------
 * clkinit - initialize the clock and sleep queue (called at startup)
 *------------------------------------------------------------------------
 */
clkinit()
{
	unsigned *vector;

	vector = (unsigned *) CVECTOR;	/* set up interrupt vector	*/
	*vector++ = (unsigned) clkint;	/* IP offset			*/
	*vector = 0x00;			/* Code Segment base address	*/

	setclkr();			/* initialize the clock		*/
					/* and enable clock interrupts  */

	outbyte( PICMASK,inbyte(PICMASK) & ~CLKINTR );

	preempt = QUANTUM;		/* initial time quantum		*/
	slnempty = FALSE;		/* initially, no process asleep	*/
	clockq = newqueue();		/* allocate clock queue in q	*/
}
