	.text
/*
* siopoll
* poll 8251A status
* ARG(1) = 8251A status port address
*/
	TXRDY =	0001
	.globl	_siopoll
_siopoll:	
	push    bp	       /* set up linkage for C callable  */
	mov    bp,sp	       /* procedure			*/
	push   si
	push   di
	mov	dx,*4(bp)	/* 8251A status port address is arg 1	*/
afull:	in	     		/* read port status		*/
	andb	al,#TXRDY	/* check TxRdy bit		*/
	je	afull		/* try again if TxRdy bit is 0	*/
	lea     sp,*-4(bp)      /* return			*/
	pop	di
	pop	si
	pop	bp
	ret
/*
* txintoff
* turn off txen line on 8251A
* 8251A will not interrupt 8086 when empty
* no arg's
*/
	TXENOFF=0x37		/* control word to turn off txrdy pin */
	TXENON =0x36		/* control word to turn on txrdy pin  */
	STATUS= 0x00DA		/* 8251A control port address	      */
	.globl	_txintoff
_txintoff:
	push	bp	       /* linkage for C callable interface	*/
	mov	bp,sp
	push	si
	push	di
	mov	dx,#STATUS	/* 8251A control port address	      */
	movb    al,#TXENOFF    
	out	STATUS		/* write control word to port	      */
	lea     sp,*-4(bp)      /* return			*/
	pop	di
	pop	si
	pop	bp
	ret
/*
* txinton
* turn on txrdy pin on 8251A
* no arg's
*/
	.globl	_txinton
_txinton:
	push	bp	       /* this entry point is C callable */
	mov	bp,sp
	push	si
	push	di
	mov	dx,#STATUS	/* 8251A control port address	 */
	movb	al,#TXENON	/* load control word		 */
	out	STATUS		/* write control word to port	 */
	lea     sp,*-4(bp)      /* return			*/
	pop	di
	pop	si
	pop	bp
	ret
