/*
 * This file (udp.h) contains definitions of constants and data types
 * specific to the US DOD Arpa Internet Protocol
 */

/* Registered Ports */
#define	NAMEPORT 42
#define SINKPORT 9
#define TFTPPORT 69

/* Internet Name Server Protocol Constants */
#define ITEMHDRLEN 2
#define NAME_CODE 1
#define ADDR_CODE 2
#define ERR_CODE 3

/* libtftp transfer modes */
#define TFTP_READ 0
#define TFTP_WRITE 1
#define TFTP_BINARY 0
#define TFTP_ASCII 1

/* Configuration Register Bits */
#define EN_CONFIG	0x0200
#define EC_CONFIG 	0x0400

#define IPMask  0xffffff00	/* mask out Class C net name 		*/
#define HstMask ~IPMask		/* mask out Class C host name		*/
#define BADHOSTADDR 0xffffffff	/* illegal internet host address	*/

/* Link Level Type Field Values */
#define EN_IP 01001
#define EC_IP 0x800
#define EC_ARP 0x0806


/*===========================================================================
 *     Following defines the IP->UDP packet data type
 *=========================================================================*/

#define	Fragment	0x3fff	/* mask frag flag, and  frag. offset	*/
#define	FragOffset	0x1fff	/* mask the fragment offset		*/
#define HDR_LENGTH	0xf	/* mask the ihl part of version-ihl	*/
#define Version		0xf0	/* mask the version part of version-ihl	*/
#define CurrentInternetVersion	4<<4	/* Version 4			*/
#define UDPPROTO	17	/* user datagram protocol number	*/
#define MAXIPLEN	576
#define MAXUDPDATALEN	(MAXIPLEN - 20 - 8)

typedef
struct _udp_packet
  {
	char	VersionIhl;	/* 16 + header_length in longs		*/
	char	SvcType;	/* 0 (no abnormal service)		*/
	short	length;		/* packet length in bytes <= 576	*/
	short	id;		/* 0 (no fragments)			*/
	short	FlagsFragOffset;/* 0 (no fragments)			*/
	char	TimeToLive;	/* origin: 15; decrement on receipt	*/
	char	protocol;	/* type of data 			*/
	unsigned short	checksum;/* ~(1's cmp. sum of shorts in header)	*/
	char	source[4];
	char	dest[4];
	short	srcport;
	short	dstport;
	short	udp_length;
	short	udp_checksum;
	char	data[MAXUDPDATALEN];
  }
    udp_packet;

/*------------------------------------------------------------------------
 * Data structures for upper-level UDP routines
 *------------------------------------------------------------------------
 */

struct	udpblk {
	int	udp_id;			/* pseudo-device descriptor	*/
	int	udp_pid;		/* id of process using device	*/
	short	udp_lpnum;		/* local UDP port number	*/
	short	udp_rpnum;		/* remote UDP port number	*/
	char	udp_ripaddr[IP_ADDR_SIZE]; /* remote host IP address	*/
	char	udp_retheraddr[ETHER_ADDR_SIZE]; /*remote ethernet addr.*/
	int	udp_iport;		/* port for incoming packets	*/
};
extern struct udpblk	udptab[];
