/* rfile.h */

/************************************************************************/
/* remote file device control block and defined constants.  A process	*/
/* opens the RFILESYS device giving a file name and access mode.  The	*/
/* name must correspond to a legal file name on the remote system	*/
/* (e.g., be a valid UNIX path name).  Open(RFILESYS,name,mode) returns	*/
/* a the device descriptor that the process can then use to access	*/
/* the file with read, write, or seek operations.  When finished using	*/
/* the file, the process must deallocate the device descriptor by	*/
/* calling close.							*/
/*									*/
/* The implementation is straightforward.  It uses the remote server	*/
/* to perform each read or write operation without buffering (caching)	*/
/* data locally.  This scheme avoids the problem of cache inconsistency	*/
/* among a set of machines, but introduces more overhead per operation.	*/
/* The premise is that buffering can be added with another layer of	*/
/* software when the user wants efficient sequential access.		*/
/*									*/
/************************************************************************/

#include <file.h>

/* constants for server device control functions */

#define	RFCLEAR		1		/* clear incoming messages	*/

/* constants controlling retries for server communication */

#define	RTIMOUT		4		/* timeout for server response	*/
#define	RMAXTRY		2		/* number of trys per packet	*/

/* constants for rf pseudo-device state variable */

#define	RFREE		-1		/* this pseudo-device is unused	*/
#define	RUSED		0		/* this pseudo-device is used	*/

/* declaration of rf pseudo-device io control block */

struct	rfblk	{			/* remote file buffer cache	*/
	int	rf_id;			/* file's device id in devtab	*/
	char	rf_name[RNAMLEN];	/* name of remote file		*/
	int	rf_state;		/* state of this pseudo file	*/
	int	rf_mode;		/* FLREAD, FLWRITE, or both	*/
	int	rf_mutex;		/* exclusion for this file	*/
	long	rf_pos;			/* current position (in bytes)	*/
};

#ifdef	Nrf
extern	int	rfserver;		/* remote server device number	*/
extern	int	rfmutex;		/* mutual exclusion for server	*/
extern	struct	rfblk	rftab[];	/* remote file control blocks	*/
#endif
