/* kernel.h - disable, enable, inton, intoff, halt, restore, isodd */

/* Symbolic constants used throughout Xinu */

typedef	char		Bool;		/* Boolean type			*/
#define	FALSE		0		/* Boolean constants		*/
#define	TRUE		1
#define	NULL		(char *)0	/* Null pointer for linked lists*/
#define	SYSCALL		int		/* System call declaration	*/
#define	LOCAL		static		/* Local procedure declaration	*/
#define	INTPROC		int		/* Interrupt procedure  "	*/
#define	PROCESS		int		/* Process declaration		*/
#define	RESCHYES	1		/* tell	ready to reschedule	*/
#define	RESCHNO		0		/* tell	ready not to resch.	*/
#define	MININT		0100000		/* minimum integer (-32768)	*/
#define	MAXINT		0077777		/* maximum integer ( 32767)	*/
#define	SP		5		/* Stack is stored in position 5*/
#define	PC		13		/* Pc is stored in position 13	*/
#define	PS		0		/* Flags are stored in position0*/
#define	MINSTK		40		/* minimum process stack size	*/
#define	NULLSTK		300		/* process 0 stack size		*/
/*#define	DISABLE		 02		*//* PS to disable interrupts
					   Note this is only the upper
					   half of the flags register	*/
#define	OK		 1		/* returned when system	call ok	*/
#define	SYSERR		-1		/* returned when sys. call fails*/

/* initialization constants */

#define	INITARGC	1		/* initial process argc		*/
#define	INITSTK		200		/* initial process stack	*/
#define	INITPRIO	20		/* initial process priority	*/
#define	INITNAME	"main"		/* initial process name		*/
#define	INITRET		userret		/* processes return address	*/
#define	INITPS		01000		/* initial process PS		*/
#define	INITREG		0		/* initial register contents	*/
#define	QUANTUM		10		/* clock ticks until preemption	*/

/* Programmable Interrupt Controller Defined Constants			*/

#define PICMASK	0xc2	/* port address of PIC mask register 		*/
#define	RXINTR	0x10	/* PIC mask bit assigned to USART receiver 	*/
#define TXINTR	0x08	/* PIC mask bit assigned to USART transmitter 	*/
#define NOINTR  0x00	/* PIC mask to disable all interrupts       	*/
#define CLKINTR 0x01	/* PIC mask bit assigned to realtime clock	*/
#define I550INTR 0x20	/* PIC mask bit assigned to i550 controller	*/

/* misc. utility inline	functions */

#define	isodd(x)	(01&(int)(x))

#define	disable(ps)	asm ("doit ps"); asm("	 push ax");\
			asm("	 pushf"); \
			asm("	pop ax"); asm("	movb ps,ah"); \
			asm("	cli"); asm("	pop ax")

#define	restore(ps)	asm ("doit ps"); asm("	push ax"); \
			asm("	movb ah,ps"); asm("	xorb al,al"); \
			asm("	push ax"); asm("	popf");		\
			asm("	pop ax") 

#define	enable()	asm("	sti")		/* enable interrupts	*/
#define	pause()		enable();asm("	hlt") /* machine "wait for interr."*/
#define	halt()		asm("	hlt")	/* machine halt	instruction	*/
#define inton(addr,code)  	/* enable device interrupts at the PIC */ \
			outbyte(addr,inbyte(addr) & ~code)
#define intoff(addr,code)	/* disable device interrupts at the PIC */ \
			outbyte(addr,inbyte(addr) | code)

extern	int	rdyhead, rdytail;
extern	int	preempt;
