/* io.h -  fgetc, fputc, getchar, isbaddev, putchar */


#define INTVEC	0x0014		/* address of universal int. vector	*/
#define	INTDISP	ioint		/* interrupt dispatch routine		*/
#define INTCSR	0		/* Code Segment Register value for
				   interrupt vectors			*/
#define asmINT	0xCD		/* assembled one-byte INT instruction	*/
#define asmTRAPNO	5	/* trap through trap type 5		*/
extern	int	INTDISP();

struct	intmap	{		/* device-to-interrupt routine mapping	*/
	int	(*iin)();	/* address of input interrupt routine	*/
	int	icode;		/* argument passed to input routine	*/
	int	(*iout)();	/* address of output interrupt routine	*/
	int	ocode;		/* argument passed to output routine	*/
	};

struct	intent	{		/* fake interrupt vector for INTEL	*/
	char	ivin[2];	/* trap here on input interrupt		*/
	char	ivout[2];	/* trap here on output interrupt	*/
	};

#ifdef	NDEVS
extern	struct	intmap	intmap[NDEVS];
extern	struct	intent	inttab[NDEVS];
#define	isbaddev(f)	( (f)<0 || (f)>=NDEVS )
#endif

/* In-line I/O procedures */

#define	getchar()	getc(CONSOLE)
#define	putchar(ch)	putc(CONSOLE,(ch))
#define	fgetc(unit)	getc((unit))
#define	fputc(unit,ch)	putc((unit),(ch))

struct	vector	{
	char	*vproc;		/* address of interrupt procedure	*/
	int	vcs;		/* saved code segment register		*/
	};
