/* fserver.h */

/* Definitions of remote File Server constants and packet format */

typedef enum {SOPEN, SCLOSE, SREAD, SWRITE, SERROR} rfileop;

#define	RSERVER		"merlin:1005"	/* remote file server		*/
#define	RDATLEN		512	/* maximum characters of data sent	*/
#define	RNAMLEN		80	/* maximum characters per file name	*/
#define	RCLOSED		-1	/* server device has not been opened	*/
#ifndef	RFILSYS
#define	RFILSYS		-1	/* remote file system pseudo device	*/
#endif
#define	ANYUDP		-1	/* TEMPORARY - ONLY UNTIL rf INSTALLED	*/

struct	fpakhdr	{		/* format of server packet header	*/
	rfileop	f_op;		/* operation requested			*/
	char	f_name[RNAMLEN];/* name of file on which op performed	*/
	long	f_pos;		/* byte position in file		*/
	long	f_count;	/* count of data bytes			*/
};

struct	fpacket	{		/* format of packet sent to/from server	*/
	struct	fpakhdr	fp_h;	/* header describing data		*/
	char	fp_data[RDATLEN];/*actual data sent to/from server	*/
};
