	.text
| startup.s - start, disable and enable **	Standalone version |

| *----------------------------------------------------------------------
| *  Stand-alone startup header -- branches to main program after
| *            getting the stack pointer in place for C run-time
| *  Features: sizes memory and starts SP at highest address,
| *	       calls lowcore to initialize interrupt vectors,
| *            leaves interrupts disabled when program starts
| *            (call enable|disable to enable or disable them
| *            while running),
| *----------------------------------------------------------------------

	MAXADDR	=   0xFFFF		| maximum possible memory address
	STEP	=   0x100		| probe stride
	PATTERN	=   0x56B7		| arbitrary bit pattern

	.globl	_start
	.globl	disable
	.globl	_main
	.globl	enable
	.globl	_lowcore
_start:
	cli				| disable interrupts
	mov	bx,#MAXADDR		| set reg bx to highest possible loc.
	and	bx,#0xFFFE		| want the address of the highest WORD
sizloop:
	mov	(bx),#PATTERN		| write out pattern
	cmp	(bx),#PATTERN		| did write work?
	je	found			| yes -- found high memory loc
	sub	bx,#STEP		| no -- move to next lower address
	jmp	sizloop			| try again
found:
	mov	sp,bx			| set stack to high memory


	call	_lowcore			| initialize low core

| Initialize general and segment registers to zeros (except sp and cs)

	xor	ax,ax
	mov	bx,ax
	mov	cx,ax
	mov	dx,ax
	mov	bp,ax
	mov	si,ax
	mov	di,ax

	mov	ds,ax
	mov	ss,ax
	mov	es,ax

	jmp	_main			| transfer control to main
	hlt

disable:				| Disable interrupts
	cli
	ret
enable:					| Enable interrupts
	sti
	ret
