/*
* These functins allow C programs to easily access I/O ports mapped
* into the I/O space.  Thus, all code accessing peripherals may be
* written in C.  Only functions dealing directly with the cpu (i.e.
* accessing registers) need to be written in assembly code.  I should
* note that this is significantly slower than functions written
* entirely in assembler, but where time is not critical this method
* seems easier
*
* The following definitions are assumed.
*
* int port,byte,word;
*
* outbyte - writes one byte to the specified port.  Envoke from C with:
*	outbyte(port,byte);
* inbyte -- reads one byte from the specified port.  Envoke from C with:
*	byte = inbyte(port);
* outword - write one byte to the specified port.  Envoke from C with:
*	outword(port,word);
* inword -- reads one word from the specified port.  Envoke from C with:
*	word = insword(port);
*/
	.globl _outbyte
	.globl _inbyte
	.globl _outword
	.globl _inword
_outbyte:
	push	bp
	push	dx
	mov	bp,sp
	mov	dx,*6(bp)	/* get port address	*/
	mov	ax,*8(bp)	/* get data		*/
	out	
	pop	dx
	pop	bp
	ret
_inbyte:
	push	bp
	push	dx
	mov	bp,sp
	mov	dx,*6(bp)	/* get port address	*/
	in			/* return data in ax	*/
	pop	dx
	pop	bp
	ret
_outword:
	push	bp
	push	dx
	mov	bp,sp
	mov	dx,*6(bp)	/* get port address	*/
	mov	ax,*8(bp)	/* get data		*/
	outw
	pop	dx
	pop	bp
	ret
_inword:
	push	bp
	push	dx
	mov	bp,sp
	mov	dx,*6(bp)	/* get prot address	*/
	inw			/* return data in ax	*/
	pop	dx
	pop	bp
	ret
