#include <setjmp.h>
#include <sgtty.h>
#include <signal.h>
#include <stdio.h>
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#include "loader.h"
/*
 *===============================
 * getodt - get ODT's attention
 *===============================
 * Input state - undefined
 * Output state - immediately after ODT prompt
 */
jmp_buf alarm_env;
getodt(fd)
int fd;
{
        char buf[BUFSIZ], *atptr, *rindex();
	Bool reading;
	int (*sigsave)(), getodtalarm(), nchars;

	/* 
	 * The following hack was added by R. Droms, 11/16/84, after
	 * modifications to the iSBC 86/14 CPU board.  The modifications
	 * allow for "reset on break"; i.e., allow for LSI-11 like
	 * reset of the CPU when a break condition is received.  The
	 * hardware modifications include the addition of two
	 * jumpers and a diode.  One jumper should connect U38 pin 16
	 * (SIO chip break detect) to U30 pins 12 and 13 (74S00, used
	 * as an inverter).  The diode should be connected to U30 pin 11
	 * and a jumper to U4 pin 11 (system reset).  The diode should
	 * be connected as follows:
	 * 
	 * U30 pin 11 *------|<------* U4 pin 11
	 * 
	 * allowing U30 pin 11 to pull U4 pin 11 low, but not vice
	 * versa.
	 * (U4 pin 11 is connected to the front panel reset line, and
	 * may be pulled low externally).
	 * 
	 * The next bit of code sends a break condition to the 8086,
	 * ensuring that the 8086 will be reset prior to trying to
	 * get ODT's attention.
	 */

	/* 
	 * This code was further hacked by R. Droms, 12/4/84, to allow
	 * getodt to determine if the SBC was already running ODT, or
	 * if getodt needs to send a break to get the SBC's attention.
	 * If the SBC was already in ODT, then the uploaded registers
	 * are valid, and upload will mark the core file appropriately.
	 */

	sigsave = signal(SIGALRM, getodtalarm);
	sendodt(fd, "\r", FALSE);
	atptr = buf;
	reading=TRUE;

	/* 
	 * Begin by reading until SBC stops sending
	 */

	 for (nchars = 0; nchars < 30 && reading; nchars++) {
		alarm(20); 
		if (setjmp(alarm_env) == 0) {
			read(fd, atptr, 1);
			if ((char)(*(atptr++) & 0x7f) == '*') {
				reading = FALSE;
			}
		}
		else {
			reading = FALSE;
		}
		alarm(0);
	}

	signal(SIGALRM, sigsave);

	if ((char)(*(atptr-1) & 0x7f) == '.' && nchars < 30) {
		return(1);
	}

	/* 
	 * Need to send a break to get ODT
	 */

	ioctl(fd, TIOCSBRK, 0);
	sleep(1);
	ioctl(fd, TIOCCBRK, 0);
	
	sendodt(fd,"U",FALSE);
	sleep(2);
	sendodt(fd,"U",FALSE);
	sleep(2);
        readuntil(fd,".",buf,20);
        atptr = rindex(buf,'.');
        if ( atptr != buf && *(atptr-1) == '^' )
                readuntil(fd,".",buf,10);
	return(0);
}
getodtalarm(){

	longjmp(alarm_env, -1);
	}

/*
 *==================================================
 * readuntil - read from line until some character
 *==================================================
 */
readuntil ( fd, ch, buf, time )
int fd, time;
char *ch, *buf;
{
	settimer(time, "read timed out");
	if ( A.verbose )
		printf("IN: ");
	do {
		if ( read(fd, buf, 1) != 1 ) {
			perror(Openfiles[fd]);
			callexit(1);
		}
	if (A.verbose) 
			printf("%s",unctrl((*buf) & 0x7f));
	} while ( *buf == EOS || index(ch,*buf++) == NULL );
	*buf = EOS;
	canceltimer();
	if ( A.verbose )
		printf("\n");
}

/*
 *==============================================
 * sendodt - send a message to ODT half duplex
 *==============================================
 */
sendodt(fd, msg, wait)
int fd;
char *msg;
Bool wait;
{

	char buf[32], *ptr, tmpstr[2];
	if ( A.verbose ) {
		printf("OUT: ");
		for ( ptr=msg ; *ptr!=EOS ; ptr++ ) {
			printf("%s",unctrl(*ptr));
		}
		printf("\n");
	}
	while (*msg!=EOS) {
		write(fd,msg,1);
                if ( wait ) {	/* wait for echo */
                        tmpstr[0] = *msg;
                        tmpstr[1] = EOS;
                        readuntil(fd, tmpstr, buf, 15);
                }
		msg++;
	}
}

/*
 *==========================================
 * setreg - preload a register through ODT
 *==========================================
 */
setreg(fd, reg, value)
int fd, value;
char *reg;
{
	char buf[32];
        sprintf(buf,"X%2s = %4x\r",reg,(value & 0xffff));
	sendodt(fd,buf,TRUE);
        if ( A.verbose )
                displayreg(reg,value);
	readuntil(fd,".",buf,10);
}
