/*
 * 8086users  --  list users who have an 8086 on reserve
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "/usr/ftp/pub/Xinu.8086/include/getdev.h"
#define NDEVS 5

char	tmplock[MAXNAMELEN];
char	convert[MAXNAMELEN];

main(argc, argv)
int argc;
char *argv[];
{
	int	i;
	char	user[200];
	char	*index();
	int	idle;
	struct	stat	sbuf;
	long	now, time();

        if ( argc > 1 ) {
		fprintf(stderr, "%s: argument unexpected\n", argv[0]);
		exit(1);
	}
	sprintf(convert, DEVNAME, TMPDIR, "8086"); 

	for (i=0 ; i<NDEVS ; i++) {
		sprintf(tmplock, convert, i);
		if (stat(tmplock, &sbuf) < 0)
			continue;
		getpw(sbuf.st_uid, user);
		*index(user, ':') = '\0';
		now = time(0L);
		idle = (( (int) (now-sbuf.st_mtime) ) + 30) / 60;
		printf("8086 #%d  idle time = %3d mins.  Reserved by %4s\n",
			i, idle, user);
	}
	exit(0);
}
