
/*
 * header for "core86" files
 */
#define	REGISTERS 13
#define	NREGS	  REGISTERS+1	/* including FLAGS */
#define	COREMAGIC 0477
struct core86 {
	short c_magic;
	short c_size;
	short c_regs[REGISTERS];
	short c_fl;
	short c_reg_valid;		/* 0 => not valid */
					/* other => valid */
};
static char *regname[NREGS] = {
	"ax","bx","cx","dx","sp","bp","si",
		"di","cs","ds","ss","es","fl","ip"};
#define AX	0
#define BX	1
#define CX	2
#define DX	3
#define SP	4
#define BP	5
#define SI	6
#define DI	7
#define CS	8
#define DS	9
#define SS	10
#define ES	11
#define	FL	12
#define IP	13

