#include <conf.h>
#define NPROD 10000
#define NBUF 10
#define TRUE 1
#define FALSE 0
#define EVEN 0
#define ODD 1

int rgw[NBUF];			/* circular buffer */
int icons=0, iprod=0;		/* indices to retrieve and store numbers */
int nonfull;			/* sem to determine if buff can be filled */
int nonempty;			/* sem to determine if buff can be emptied */
int lock;			/* sem to lock buffer for the producers */

/*****
 * main() - use two producers to produce even and odd numbers to be
 *	consumed by a consumer from a circular buffer
 *****/
main()
{
    int wnum, prod();
    int ceven=0, codd=0;	/* number of even & odd numbers consumed */

    /* create the semaphores */
    nonfull = screate(NBUF);
    nonempty = screate(0);
    lock = screate(1);

    /* create the two producers, one produces ODD, and one produces EVEN */
    resume(create(prod,200,20,"proc 1",1,EVEN));
    resume(create(prod,200,20,"proc 2",1,ODD));

    while ((ceven+codd) < NPROD) {	/* have all produced been consumed? */
        wait(nonempty);
	wnum = rgw[icons++ % NBUF];	/* get the number */
	signal(nonfull);
	if ((wnum % 2) == 0) 
	    if ((wnum % 10) == 0)	/* print out counts */
		kprintf("even count =%4d,  odd count =%4d\n",++ceven,codd);
	    else
		ceven++;		/* another even seen */
	else
	    codd++;			/* another odd seen */
	}

    /* delete semaphores and print final counts */
    sdelete(nonfull);
    sdelete(nonempty);
    sdelete(lock);
    kprintf("\nfinal even count =%4d,  final odd count =%4d\n",ceven,codd);
}

/*******
 * prod(wkey) - produce even or odd numbers (depending whether wkey = 0 or 1)
 *	and place number in the buffer
 *******/
prod(wkey)
int wkey;
{
    int wnum;
    int done=FALSE;

    while (!done) {
	wnum = rand();			/* get a random number */
	if ((wnum % 2) == wkey) {	/* is it valid? */
	    wait(nonfull);		/* is there room? */
	    wait(lock);			/* does the other prod. have buffer? */
	    if (iprod >= NPROD)		/* produce a set number */
		done = TRUE;
	    else
	        rgw[iprod++ % NBUF] = wnum; 	/* put in buffer */
	    signal(lock);
	    signal(nonempty);
	    }
	}
}

