#include <conf.h>

#define NPROD 100
#define NBUF 10
#define TRUE 1
#define FALSE 0
#define EVEN 0
#define ODD 1

int rgw[NBUF];			/* circular buffer */
int cprod=0;			/* count on the number produced */
int portid;			/* id for port to store numbers */
int lock;			/* sem to lock buffer for the producers */
int (*dispose)();		/* function used in pdelete */

/*****
 * main() - use two producers to produce even and odd numbers to be
 *	consumed by a consumer using Xinu's ports
 *****/
main()
{
    int wnum, prod(), *pw;
    int ceven=0, codd=0;	/* number of even & odd numbers consumed */

    /* create the port and lock semaphore */
    kprintf ( "creating a port with %d outstanding messages\n", NBUF );
    portid = pcreate(NBUF);
    kprintf ( "created port number %d\n", portid );
    lock = screate(1);
    kprintf ( "created semaphore # %d\n", lock );

    /* create the two producers, one produces ODD, and one produces EVEN */
    resume(create(prod,200,20,"proc 1",1,EVEN));
    resume(create(prod,200,20,"proc 2",1,ODD));

    while ((ceven+codd) < NPROD) {	/* have all produced been consumed? */
	wnum = (int) preceive(portid); 	/* get number */
	if ((wnum % 2) == 0) 
	    if ((wnum % 10) == 0)	/* print out counts */
		kprintf("even count =%4d,  odd count =%4d\n",++ceven,codd);
	    else
		ceven++;		/* another even seen */
	else
	    codd++;			/* another odd seen */
	}

    /* delete port & semaphore and print final counts */
    pdelete(portid,dispose);
    sdelete(lock);
    kprintf("\nfinal even count =%4d,  final odd count =%4d\n",ceven,codd);
}

/*******
 * prod(wkey) - produce even or odd numbers (depending whether wkey = 0 or 1)
 *	and place number in the buffer
 *******/
prod(wkey)
int wkey;
{
    int wnum;
    int done=FALSE;

    while (!done) {
	wnum = rand();			/* get a random number */
        wnum = wnum % 10;
	if ((wnum % 2) == wkey) {	/* is it valid? */
	    wait(lock);			/* does the other producer have port? */
	    if (cprod >= NPROD)		/* produce a set number */
		done = TRUE;
	    else {
		cprod++;			/* update count on # produced */
		psend(portid,(char *) wnum);	/* put number in port */
		}
	    signal(lock);
	    }
	}
}
