#include <kernel.h>

#define NUMNOTE   1                 /* global names for main.c           */
#define SIZENOTE  1
#define ALLPROC   16

#define  VACANT     0               /* global names for note.c           */
#define  IN_USE     1
#define  MAXBOX     10              /* maximum number of note boxes      */
#define  MAXNOTE    1000            /* maximum number of notes in system */
#define  USRPERCENT 40              /* maximum percent of notes one user */
                                    /*       can declare for one notebox */
  


                /*     header for notebox routines  */

struct   note   {
                  int           note_info;
                  int           pid;
                  struct note   *pnote;
                };

struct   notebox {
                   int          seqnum;
                   int          state;
                   struct note  *pHead;
                   struct note  *pTail;
                   int          nboxsize;
                   int          NotFull;
                   int          NotEmpty;
                 };







int    nid, all_done;

main ( )              /*  the following program tests the NoteBox routines  */
                      /*  that exist in 'note.c'.  It will create six       */
                      /*  processes (five producers and one consumer) which */
                      /*  will create, use, and delete a notebox.           */

    {
       int i, P1( ), P2( ), C1( );
       kprintf ( "\nbegin execution ...\n" );
       InitNotes ( );
       all_done = screate ( 0 );
       kprintf ( "create the notebox\n" );
       NBoxCreate ( nid, NUMNOTE, SIZENOTE );
       kprintf ( "create the processes\n" );
       resume ( create ( P1, 10000, 20, "P1", 1, nid ) );
       resume ( create ( P1, 10000, 20, "P2", 1, nid ) );
       resume ( create ( P1, 10000, 20, "P3", 1, nid ) );
       resume ( create ( P1, 10000, 20, "P4", 1, nid ) );
       resume ( create ( P1, 10000, 20, "P5", 1, nid ) );
       resume ( create ( C1, 1000, 20, "C1", 1, nid ) );

       wait ( all_done );
       NBoxDelete ( nid );

    }


P1 ( nid )              /*  Producer  */

int nid;
    {
      int i, data;

      kprintf ( "allocated process %d\n", nid );
      for ( i=1; i <=200; i++ )
          {
            data = F91( rand( ) & 0177 );
            kprintf ( "calling PutNote : process %d  value %d\n", nid, data );
            PutNote ( data, nid );
          }
      
      PutNote ( 0, nid );
    }



C1 ( nid )            /*  Consumer Process  */
int nid; 
    {
      int i, ctzero, ct91[ALLPROC];
      struct note my_note;

      ctzero = 0;
      for ( i=0; i<ALLPROC; i++ )
          ct91[i] = 0;

      while ( ctzero < 5 ) 
         {
           GetNote ( &my_note, nid );
           kprintf ( "received GetNote : from process %d with value %d\n",
                      nid, my_note.note_info );
           if ( my_note.note_info == 91 )
              ct91[my_note.pid]++;
           else  
              if ( my_note.note_info == 0 )
                 ctzero++;
         }

      kprintf ( "\n" );
      for ( i=0; i < ALLPROC; i++ )      
          kprintf ( "Process  %d  number of 91's  %d\n", i, ct91[i] );
      signal ( all_done );
    }


F91 ( num )
int num;
   {
     if ( num > 100 ) 
        return ( num - 10 );
     else
        return ( F91 ( F91 ( num + 11 ) ) );
   }








struct note     *pFreeNote;             /* pointer to first free note */
int             ctFreeNote = MAXNOTE;   /* number of free notes       */
int             Exclusive;              /* semaphore for exclusive    */
                                        /*      use of the notebox    */

struct note     NoteList[MAXNOTE];      /* declare note space         */

struct notebox  NBoxList[MAXBOX];       /* declare notebox space      */



InitNotes ( )          /*  routine that should be done at system boot time */
                       /*  designed to accomplish the basic initialization */
                       /*  of the noteboxes and of the notebox space (link */
                       /*  together a free list of available notes)        */

    {
      struct note    *pNoteList;
      struct notebox *pBox;
      int            i;

      Exclusive = screate ( 1 );        /* semaphore for exclusive    */
                                        /*      use of the notebox    */

      pNoteList = &NoteList[0];        /* initialize Note structure */
      pFreeNote = pNoteList++;

      for ( i=1; i < MAXNOTE; i++)     /* set up linked list of free notes */
          {                            /* and set up FREE pointer          */
            pNoteList->pnote = pFreeNote;
            pFreeNote++;
            pNoteList++;
          }
      pNoteList->pnote = (struct note *) NULL;
      pFreeNote = &NoteList[0];


      pBox = &NBoxList[0];             /* initialize NBox structure */

      for ( i=1; i <= MAXBOX; i++ )    /*      -set all notebox status */
          {                            /*       to not-in-use          */
            pBox->state  = 0;
            pBox->seqnum = 0;
            pBox++;
          }

    }




NBoxCreate ( nid, ctnote, lennote )    /*  This routine is called whenever  */
                                       /*  the user wishes to create a new  */
                                       /*  notebox.  He passes the count of */
                                       /*  notes requested (int ctnote) and */
                                       /*  the length of each note in words */
                                       /*  (int lennote).  He is returned a */
                                       /*  notebox id (int nid)             */

    int  nid, ctnote, lennote;

    {
      int            i, index;
      struct notebox *pBox;

      /*  check request to ensure it does not exceed maximum allowable  */

      if ( ctnote > ctFreeNote  ||  ( ctnote > (USRPERCENT * MAXNOTE)/100 ) )
         return ( SYSERR );

      wait ( Exclusive );                   /* get exclusive use of nbox */

      i = 0;
      while ( NBoxList[i].state != VACANT )      /*  find available notebox  */
         i++;
      if ( i == MAXBOX )   
         {
           signal ( Exclusive );
           return ( SYSERR );                    /*  no free notebox, error  */
         }
      else
         {
           pBox  = &NBoxList[i];                 /*  assign free notebox     */
           index = i;
         }

      /*  initialize notebox      */

      if ( (pBox->NotFull = screate (ctnote) ) == SYSERR )   /* semaphores */
         {
           signal ( Exclusive );
           return ( SYSERR );
         }
      if ( (pBox->NotEmpty = screate (0) ) == SYSERR )       /* semaphores */
         {
           sdelete ( pBox->NotFull );
           signal  ( Exclusive );
           return ( SYSERR );
         }
      pBox->pHead  = pFreeNote;                /* set up head pointer */

      pBox->pTail  = pFreeNote;
      for ( i=1; i < ctnote; i++ )
          pBox->pTail++;                       /* set tail pointer to end */
      pFreeNote          = pBox->pTail->pnote; /* reset FREE pointer      */
      pBox->pTail->pnote = pBox->pHead;        /* complete circular queue */
     
      pBox->state    = IN_USE;                 /* mark notebox state   */
      pBox->nboxsize = ctnote;                 /* set notebox size     */
      
      ctFreeNote = ctFreeNote - ctnote;        /* decrement free notes */

      nid = (pBox->seqnum * MAXBOX) + index;   /* assign notebox id    */
   
      signal ( Exclusive );                    /* release nbox control */

      return ( OK );                           /* return properly      */
  
    }



PutNote ( user_data, nid )    /*  this routine is called whenever the user  */
                              /*  wishes to place data in his notebox.  He  */
                              /*  simply passes the actual data and the id  */
                              /*  of the notebox in which to place the data */
                              /*  (user_data and nid)                       */


    int user_data;
    int nid;

    {
      int            index;
      struct note    *next_note;
      struct notebox *pBox;


      index = nid - (nid / MAXBOX) * MAXBOX;  /* find correct index  */

      pBox = &NBoxList[index];            /* set pointer to correct nbox  */

      if ( pBox->state != IN_USE )        /* old seq num, box dead        */
           return ( SYSERR );

      wait ( pBox->NotFull );             /* wait for room to put note    */

      wait ( Exclusive );                 /* get exclusive use of notebox */

      if ( pBox->seqnum != nid )          /* old seq num, different box   */
         { 
           pBox->pHead = pBox->pHead->pnote;
           signal ( Exclusive );
           return ( SYSERR );
         }

      next_note = pBox->pHead->pnote;     /* get next note in queue       */

      next_note->note_info = user_data;             /* assign fields  */
      next_note->pid       = getpid ( );

      pBox->pHead = pBox->pHead->pnote;   /* increment head pointer       */

      signal ( Exclusive );               /* signal everything */
      signal ( pBox->NotEmpty  );

      return ( OK );

    }



GetNote ( note_ptr, nid )     /*  this routine is called whenever a user     */
                              /*  wants to retrieve information that is in   */
                              /*  a notebox.  He passes a pointer to the     */
                              /*  structure where the returned data is to be */
                              /*  stored, and the notebox id.                */

    struct note    *note_ptr;
    int         nid;

    {
      int            index;
      struct notebox *pBox;

      index = nid - (nid / MAXBOX) * MAXBOX;  /* find correct index  */

      pBox = &NBoxList[index];            /* set pointer to correct nbox  */

      if ( pBox->state != IN_USE )
           return ( SYSERR );

      wait ( pBox->NotEmpty );            /* wait for next note to exist  */

      wait ( Exclusive );                 /* get exclusive use of notebox */

      if ( pBox->seqnum != nid )          /* old seq num, different box   */
         {
           pBox->pTail = pBox->pTail->pnote;
           signal ( Exclusive );
           return ( SYSERR );
         }

      note_ptr->note_info = pBox->pTail->note_info;    /* retrieve info */
      note_ptr->pid       = pBox->pTail->pid;

      pBox->pTail = pBox->pTail->pnote;   /* increment tail pointer */

      signal ( Exclusive );               /* signal everything */
      signal ( pBox->NotFull );

      return ( OK );

    }



NBoxDelete ( nid )         /*  this routine is used to delete a notbox when */
                           /*  it is no longer needed.  The user simply     */
                           /*  passes the id of the notebox to be destroyed */
 
    int  nid;

    {
      int            index;
      struct notebox *pBox;
      struct note    *pTempNote;

      index = nid - ( nid / MAXBOX ) * MAXBOX;     /* find box index */

      pBox = &NBoxList[index];              /* set pointer to correct nbox */

      if ( pBox->state != IN_USE )
         return ( SYSERR );

      wait ( Exclusive );                   /* wait to get notebox  */

      sdelete ( pBox->NotFull );            /* delete semaphores    */
      sdelete ( pBox->NotEmpty );

      pBox->seqnum++;                       /* increment seqnum for nbox  */
      pBox->state = VACANT;                 /* reset nbox state           */

      pTempNote = pFreeNote;                /* recycle notes to FREE note */
      pFreeNote = pBox->pHead->pnote;       /*         linked list        */
      pBox->pHead->pnote = pTempNote;

      ctFreeNote = ctFreeNote + pBox->nboxsize;    /* increment number of */
                                                   /*          free notes */
      signal ( Exclusive );

    }
