/* snmib.c */

#include <conf.h>
#include <kernel.h>
#include <network.h>

#ifdef	SNMP

#include <snmp.h>
#include <mib.h>
#include <asn1.h>
#include <snmpvars.h>

extern int sntable(), snleaf();
extern struct oid SysObjectID;

/* All table and leaf variables that are found in the MIB */
struct mib_info mib[] = {
	{ "system", "", { {1}, 1}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "sysDescr", "system.", { {1, 1, 0}, 3}, ASN1_OCTSTR,
	      FALSE, LEAF, snleaf, SysDescr, 0},
	{ "sysObjectID", "system.", { {1, 2, 0}, 3}, ASN1_OBJID,
	      FALSE, LEAF, snleaf, (char *)&SysObjectID, 0},
	{ "sysUpTime", "system.", { {1, 3, 0}, 3}, ASN1_TIMETICKS,
	      FALSE, LEAF, snleaf, (char *)&SysUpTime, 0},
	{ "sysContact", "system.", { {1, 4, 0}, 3}, ASN1_OCTSTR,
	      TRUE, LEAF, snleaf, SysContact, 0},
	{ "sysName", "system.", { {1, 5, 0}, 3}, ASN1_OCTSTR,
	      TRUE, LEAF, snleaf, SysName, 0},
	{ "sysLocation", "system.", { {1, 6, 0}, 3}, ASN1_OCTSTR,
	      TRUE, LEAF, snleaf, SysLocation, 0},
	{ "sysServices", "system.", { {1, 7, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&SysServices, 0},
	{ "if", "", { {2}, 1}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "ifNumber", "if.", { {2, 1, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&IfNumber, 0},
	{ "ifTable", "if.", { {2, 2}, 2}, T_AGGREGATE,
	      TRUE, NLEAF, 0, 0, 0},
	{ "ifEntry", "if.ifTable.", { {2, 2, 1}, 3}, T_TABLE,
	      TRUE, NLEAF, sntable, (char *)&tabtab[T_IFTABLE], 0},
	{ "at", "", { {3}, 1}, T_AGGREGATE,
	      TRUE, NLEAF, 0, 0, 0},
	{ "atTable", "at.", { {3, 1}, 2}, T_AGGREGATE,
	      TRUE, NLEAF, 0, 0, 0},
	{ "atEntry", "at.atTable.", { {3, 1, 1}, 3}, T_TABLE,
	      TRUE, NLEAF, sntable, (char *)&tabtab[T_ATTABLE], 0},
	{ "ip", "", { {4}, 1}, T_AGGREGATE,
	      TRUE, NLEAF, 0, 0, 0},
	{ "ipForwarding", "ip.", { {4, 1, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&IpForwarding, 0},
	{ "ipDefaultTTL", "ip.", { {4, 2, 0}, 3}, ASN1_INT,
	      TRUE, LEAF, snleaf, (char *)&IpDefaultTTL, 0},
	{ "ipInReceives", "ip.", { {4, 3, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpInReceives, 0},
	{ "ipInHdrErrors", "ip.", { {4, 4, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpInHdrErrors, 0},
	{ "ipInAddrErrors", "ip.", { {4, 5, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpInAddrErrors, 0},
	{ "ipForwDatagrams", "ip.", { {4, 6, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpForwDatagrams, 0},
	{ "ipInUnknownProtos", "ip.", { {4, 7, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpInUnknownProtos, 0},
	{ "ipInDiscards", "ip.", { {4, 8, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpInDiscards, 0},
	{ "ipInDelivers", "ip.", { {4, 9, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpInDelivers, 0},
	{ "ipOutRequests", "ip.", { {4, 10, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpOutRequests, 0},
	{ "ipOutDiscards", "ip.", { {4, 11, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpOutDiscards, 0},
	{ "ipOutNoRoutes", "ip.", { {4, 12, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpOutNoRoutes, 0},
	{ "ipReasmTimeout", "ip.", { {4, 13, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&IpReasmTimeout, 0},
	{ "ipReasmReqds", "ip.", { {4, 14, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpReasmReqds, 0},
	{ "ipReasmOKs", "ip.", { {4, 15, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpReasmOKs, 0},
	{ "ipReasmFails", "ip.", { {4, 16, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpReasmFails, 0},
	{ "ipFragOKs", "ip.", { {4, 17, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpFragOKs, 0},
	{ "ipFragFails", "ip.", { {4, 18, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpFragFails, 0},
	{ "ipFragCreates", "ip.", { {4, 19, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IpFragCreates, 0},
	{ "ipAddrTable", "ip.", { {4, 20}, 2}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "ipAddrEntry", "ip.ipAddrTable.", { {4, 20, 1}, 3}, T_TABLE,
	      FALSE, NLEAF, sntable, (char *)&tabtab[T_AETABLE], 0},
	{ "ipRoutingTable", "ip.", { {4, 21}, 2}, T_AGGREGATE,
	      TRUE, NLEAF, 0, 0, 0},
	{ "ipRouteEntry", "ip.ipRoutingTable.", { {4, 21, 1}, 3}, T_TABLE,
	      TRUE, NLEAF, sntable, (char *)&tabtab[T_RTTABLE], 0},
	{ "ipRoutingDiscards", "ip.", { {4, 23, 0}, 3}, ASN1_COUNTER,
              FALSE, NLEAF, snleaf, (char *)&IpRoutingDiscards, 0},
	{ "icmp", "", { {5}, 1}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "icmpInMsgs", "icmp.", { {5, 1, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInMsgs, 0},
	{ "icmpInErrors", "icmp.", { {5, 2, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInErrors, 0},
	{ "icmpInDestUnreachs", "icmp.", { {5, 3, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInDestUnreachs, 0},
	{ "icmpInTimeExcds", "icmp.", { {5, 4, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInTimeExcds, 0},
	{ "icmpInParmProbs", "icmp.", { {5, 5, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInParmProbs, 0},
	{ "icmpInSrcQuenchs", "icmp.", { {5, 6, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInSrcQuenchs, 0},
	{ "icmpInRedirects", "icmp.", { {5, 7, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInRedirects, 0},
	{ "icmpInEchos", "icmp.", { {5, 8, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInEchos, 0},
	{ "icmpInEchoReps", "icmp.", { {5, 9, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInEchoReps, 0},
	{ "icmpInTimestamps", "icmp.", { {5, 10, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInTimestamps, 0},
	{ "icmpInTimestampReps", "icmp.", { {5, 11, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInTimestampReps, 0},
	{ "icmpInAddrMasks", "icmp.", { {5, 12, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInAddrMasks, 0},
	{ "icmpInAddrMaskReps", "icmp.", { {5, 13, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpInAddrMaskReps, 0},
	{ "icmpOutMsgs", "icmp.", { {5, 14, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutMsgs, 0},
	{ "icmpOutErrors", "icmp.", { {5, 15, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutErrors, 0},
	{ "icmpOutDestUnreachs", "icmp.", { {5, 16, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutDestUnreachs, 0},
	{ "icmpOutTimeExcds", "icmp.", { {5, 17, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutTimeExcds, 0},
	{ "icmpOutParmProbs", "icmp.", { {5, 18, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutParmProbs, 0},
	{ "icmpOutSrcQuenchs", "icmp.", { {5, 19, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutSrcQuenchs, 0},
	{ "icmpOutRedirects", "icmp.", { {5, 20, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutRedirects, 0},
	{ "icmpOutEchos", "icmp.", { {5, 21, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutEchos, 0},
	{ "icmpOutEchoReps", "icmp.", { {5, 22, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutEchoReps, 0},
	{ "icmpOutTimestamps", "icmp.", { {5, 23, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutTimestamps, 0},
	{ "icmpOutTimestampReps","icmp.", { {5, 24, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutTimestampReps, 0},
	{ "icmpOutAddrMasks", "icmp.", { {5, 25, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutAddrMasks, 0},
	{ "icmpOutAddrMaskReps", "icmp.", { {5, 26, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&IcmpOutAddrMaskReps, 0},
	{ "tcp", "", { {6}, 1}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "tcpRtoAlgorithm", "tcp.", { {6, 1, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&TcpRtoAlgorithm, 0},
	{ "tcpRtoMin", "tcp.", { {6, 2, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&TcpRtoMin, 0},
	{ "tcpRtoMax", "tcp.", { {6, 3, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&TcpRtoMax, 0},
	{ "tcpMaxConn", "tcp.", { {6, 4, 0}, 3}, ASN1_INT,
	      FALSE, LEAF, snleaf, (char *)&TcpMaxConn, 0},
	{ "tcpActiveOpens", "tcp.", { {6, 5, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpActiveOpens, 0},
	{ "tcpPassiveOpens", "tcp.", { {6, 6, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpPassiveOpens, 0},
	{ "tcpAttemptFails", "tcp.", { {6, 7, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpAttemptFails, 0},
	{ "tcpEstabResets", "tcp.", { {6, 8, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpEstabResets, 0},
	{ "tcpCurrEstab", "tcp.", { {6, 9, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpCurrEstab, 0},
	{ "tcpInSegs", "tcp.", { {6, 10, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpInSegs, 0},
	{ "tcpOutSegs", "tcp.", { {6, 11, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpOutSegs, 0},
	{ "tcpRetransSegs", "tcp.", { {6, 12, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&TcpRetransSegs, 0},
	{ "tcpConnTable", "tcp.", { {6, 13}, 2}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "tcpConnEntry", "tcp.tcpConnTable.", { {6, 13, 1}, 3}, T_TABLE,
	      FALSE, NLEAF, sntable, (char *)&tabtab[T_TCPTABLE], 0},
	{ "udp", "", { {7}, 1}, T_AGGREGATE,
	      FALSE, NLEAF, 0, 0, 0},
	{ "udpInDatagrams", "udp.", { {7, 1, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&UdpInDatagrams, 0},
	{ "udpNoPorts", "udp.", { {7, 2, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&UdpNoPorts, 0},
	{ "udpInErrors", "udp.", { {7, 3, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&UdpInErrors, 0}, 
	{ "udpOutDatagrams", "udp.", { {7, 4, 0}, 3}, ASN1_COUNTER,
	      FALSE, LEAF, snleaf, (char *)&UdpOutDatagrams, 0}
};

int mib_entries = sizeof(mib) / sizeof(struct mib_info);

/* Funcs that implement get,getfirst,getnext,set, and match for tables	*/
extern int
	stc_get(),	stc_getf(),	stc_getn(),	stc_set(),
	stc_match(),	srt_get(),	srt_getf(),	srt_getn(),
	srt_set(),	srt_match(),	sae_get(),	sae_getf(),
	sae_getn(),	sae_set(),	sae_match(),	sat_get(),
	sat_getf(),	sat_getn(),	sat_set(),	sat_match(),
	sif_get(),	sif_getf(),	sif_getn(),	sif_set(),
	sif_match();

struct tab_info tabtab[] = {
	{ stc_get, stc_getf, stc_getn, stc_set, stc_match, 0, },
	{ srt_get, srt_getf, srt_getn, srt_set, srt_match, 0, },
	{ sae_get, sae_getf, sae_getn, sae_set, sae_match, 0, },
	{ sat_get, sat_getf, sat_getn, sat_set, sat_match, 0, },
	{ sif_get, sif_getf, sif_getn, sif_set, sif_match, 0 }
};
#endif	/* SNMP */
