/*	$NetBSD: bootconfig.h,v 1.10 2018/06/18 13:05:20 jmcneill Exp $	*/

/*
 * Copyright (c) 1994 Mark Brinicombe.
 * Copyright (c) 1994 Brini.
 * All rights reserved.
 *
 * This code is derived from software written for Brini by Mark Brinicombe
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Mark Brinicombe
 *	for the NetBSD Project.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _EVBARM_BOOTCONFIG_H
#define _EVBARM_BOOTCONFIG_H

#ifdef _KERNEL_OPT
#include "opt_machdep.h"
#include "opt_bootconfig.h"
#endif

#include <arm/bootconfig.h>

typedef struct _PhysMem {
	u_long address;
	u_int pages;
	u_int flags;
#define BOOT_DRAM_CAN_DMA 1	/* Can DMA direct to this memory.  */
#define BOOT_DRAM_PREFER  2	/* UVM should prefer this memory.  */
} PhysMem;

#ifndef	DRAM_BLOCKS
#define	DRAM_BLOCKS	2
#endif

typedef struct _BootConfig {
	u_int dramblocks;
	PhysMem dram[DRAM_BLOCKS];
} BootConfig;

extern BootConfig bootconfig;
#define MAX_BOOT_STRING 255

#endif

/* End of bootconfig.h */
