/* 
 * Mach Operating System
 * Copyright (c) 1995 Johannes Helander
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * JOHANNES HELANDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  JOHANNES HELANDER DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 */
/*
 * HISTORY
 * $Log: $
 */
/* 
 *	File:	e_osf1.c
 *	Author:	Johannes Helander, Helsinki University of Technology, 1995.
 *
 *	Emulation for OSF/1 system calls on the Alpha.
 */

#include <e_defs.h>

#include <e_templates.h>
DEF_STAT(osf1)
DEF_LSTAT(osf1)
DEF_FSTAT(osf1)

errno_t e_osf1_mmap(
	caddr_t		addr,
	size_t		len,
	int		prot,
	int		flags,
	int		fd,
	off_t		offset,
	caddr_t		*addr_out)
{
	errno_t err;
	int newprot = 0;
	int newflags = 0;

/* UX values */
#define UX43_MAP_PRIVATE	2
#define UX43_MAP_SHARED	1

#define UX43_PROT_READ	1
#define UX43_PROT_WRITE	2
#define UX43_PROT_EXEC	4

	/* Fixup parameters */
	if (prot & UX43_PROT_READ) {
		newprot = PROT_READ;
	}
	if (prot & UX43_PROT_WRITE) {
		newprot |= PROT_WRITE;
	}
	if (prot & UX43_PROT_EXEC) {
		newprot |= PROT_EXEC;
	}

	if (flags & UX43_MAP_SHARED) {
		newflags = MAP_SHARED;
		flags &= ~UX43_MAP_SHARED;
	}
	if (flags & UX43_MAP_PRIVATE) {
		newflags = MAP_PRIVATE;
		flags &= ~UX43_MAP_PRIVATE;
	}
	newflags |= flags;	/* pass the rest on */

	return e_mmap(addr, len, newprot, newflags, fd, offset, addr_out);
}

errno_t e_64_pipe(integer_t *fds)
{
	int fd[2];
	errno_t err;

	err = e_pipe(fd);
	if (err)
	  return err;
	fds[0] = fd[0];
	fds[1] = fd[1];
	return ESUCCESS;
}

errno_t e_osf1_getuid(natural_t uids[2])
{
	errno_t err;

	err = e_getuid((uid_t *) &uids[0]);
	if (!err)
	    err = e_geteuid((uid_t *) &uids[1]);
	return err;
}

errno_t e_osf1_getgid(natural_t gids[2])
{
	errno_t err;

	err = e_getgid((gid_t *) &gids[0]);
	if (!err)
	    err = e_getegid((gid_t *) &gids[1]);
	return err;
}
