//
// hfstools - a Macintosh filesystem access tool
// (C) Copyright 1993 by Equivalence
//
// This file part of hfs.
//
// hfs is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// hfs is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with hfs; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
//
//
// $Id: config.h,v 1.5 1994/01/11 00:41:01 craigs Exp $
// $Log: config.h,v $
// Revision 1.5  1994/01/11  00:41:01  craigs
// Added STRNICMP macro to make strncasecmp portable
//
// Revision 1.4  1994/01/06  03:05:08  craigs
// Final checkin to include GNU header
//
// Revision 1.3  1993/12/23  15:16:00  craigs
// Changed default HFS device to a:
//
// Revision 1.2  1993/12/16  20:15:02  craigs
// Changed name of environment variable to match the name of
// the new executable
//
// Revision 1.1  1993/11/22  22:27:51  craigs
// Initial revision
//
//
//

#ifndef _CONFIG_H
#define _CONFIG_H

//
// environment variable used to set different disk device
//
#define DISK_DEVICE_ENV   "HFS_DEVICE"

//
// default disk device if not set in Makefile
//
#ifndef DEFAULT_DISK_DEVICE
#define DEFAULT_DISK_DEVICE "a:"
#endif

//
// name of file stored in user's home directory which stores
// the volume name and current directory
//
#ifndef STAT_FILE
#define STAT_FILE   ".macdir"
#endif

#if defined(_MSDOS) || defined(WIN32)
#define STRNICMP strnicmp
#else
#define STRNICMP strncasecmp
#endif



#endif
