
import netscape.server.applet.HttpApplet;
import netscape.server.applet.Misconfiguration;

import java.io.File;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Random;
import java.lang.Math;
import java.util.Date;


/**
 * This script is a simple image switcher. It constructs an HTML page with
 * a randomly selected image, and information about when the file was last
 * modified. It demonstrates filesystem access, accessing the Last Modified
 * time of a file, and virtual to physical translation.
 * 
 * This script takes one parameter, vpath, which specifies the virtual path
 * to a directory full of images to select from. A virtual path is simply a 
 * URL without the http://hostname part. 
 * 
 * Rob McCool
 */
class RandomApplet extends HttpApplet {
    static int lastrand = 0;

    public void run() throws Exception {
        String vpath = getConfigProperty("vpath");
        File finfo;
        Date d;
        Random rng;
        String files[];
        int x;

        // If there was no vpath given, try to find one from path info.
        if(vpath == null) {
            vpath = getServerProperty("path-info");
            if(vpath == null) {
                if (returnNormalResponse("text/html")) {
                    PrintStream out = getOutputStream();
                    out.print(usage);
                    return;
                }
            }
        }
        String dirpath = translateURI(vpath);
        File dir = new File(dirpath);

        // I keep the last generated random number around, because the 
        // Random class uses the current time as a seed. If I didn't do this,
        // you could press reload too fast and see the same picture a lot.
        if (lastrand == 0)
            rng = new Random();
        else
            rng = new Random(lastrand);

        // See if the given path exists, and is a directory. 
        if (!dir.isDirectory()) {
	    throw new Misconfiguration(dirpath + " is not a directory");
        }
        files = dir.list();

        // Return the page to the client.
	lastrand = rng.nextInt();
	x = Math.abs(lastrand % files.length);
	finfo = new File(dirpath + "/" + files[x]);
	d = new Date(finfo.lastModified());
	if (returnNormalResponse("text/html")) {
	    PrintStream out = getOutputStream();
	    out.print(header);
	    out.println("<img src=\"" + vpath + "/" + files[x] + "\"><p>");
	    out.println("This file was last modified on " + d);
	    out.print(trailer);
	}
    }

    static private String header = 
        "<html><title>Randomizer</title><h1>Randomizer</h1>" + 
        "This is a randomly selected image from an archive of ray traced " + 
        "images off of USENET.<p>" + 
        "This page was generated by a server side Java program</b></a>." +
        "<p>";
    static private String trailer = 
        "</html>\n";

    static private String usage = 
        "<html><title>Randomizer</title><H1>Randomizer</h1>" +
        "Usage error: You must provide a virtual path to the images you want "+
        "to select from as path information. For example, access<p>" + 
        "<b><a href=/server-java/RandomApplet/ns-icons>" + 
        "/server-java/RandomApplet/ns-icons</a></b>" + 
        "</html>";
}
