import netscape.server.applet.HttpApplet;

import java.io.PrintStream;
import java.io.IOException;
import java.net.Socket;
import java.net.InetAddress;
import java.lang.IndexOutOfBoundsException;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * This class demonstrates how to construct a simple form handler. By 
 * making this script the ACTION url from your HTML form, it will print out
 * a bullet list of name=value pairs from the form. 
 * 
 * Rob McCool & Warren Harris
 */
class FormApplet extends HttpApplet {

    public void run() throws Exception {
        Hashtable formdata;
        int x;
	PrintStream out = getOutputStream();

	/*
	** The getFormData method will throw an IOException
	** error if the client's data was incorrect.
	*/
	try {
	    formdata = getFormData();
	}
	catch (IOException ae) {
	    if (returnErrorResponse("text/html", BAD_REQUEST)) {
		out.println("Your form data was illegal. Reason: <b>" +
			    ae + "</b>");
	    }
	    return;
	}
	
	/*
	** Construct the HTML for our summary of the form data.  The form
	** data is in a Hashtable, which each have a
	** name String, and a value String.
	*/
	if (returnNormalResponse("text/html")) {
	    out.print(header);
	    Enumeration keys = formdata.keys();
	    Enumeration values = formdata.elements();
	    while (keys.hasMoreElements()) {
		String name = (String)keys.nextElement();
		String value = (String)values.nextElement();
		out.println("<li><code>" + name + " = " +
			    value + "</code>");
	    }
	    out.print(trailer);
	}
    }

    private static final String header = "<h1>Form results</h1>\n<ul>\n";
    private static final String trailer = "</ul>\n";
}
