import netscape.server.applet.HttpApplet;

import java.io.PrintStream;
import java.net.Socket;
import java.net.InetAddress;

/**
 * This class demonstrates how to get various pieces of information about
 * the remote browser, such as its type, their IP address or host name,
 * and what HTTP method they used to access this class. It also demonstrates
 * getting various server configuration information.
 *
 * Rob McCool & Warren Harris
 */
public class BrowserDataApplet extends HttpApplet {

    BrowserDataApplet() {}

    public void run() throws Exception {
	Socket sock = getClientSocket();
        String remoteHost = sock.getInetAddress().getHostName();
        String remoteSW = getHeader("user-agent");
        String method = getMethod();
        String path = getServerProperty("path");

	if (returnNormalResponse("text/plain")) {
	    PrintStream out = getOutputStream();
	    out.println("Hello " + remoteHost);
	    if (remoteSW != null)
		out.println("You're using " + remoteSW);
	    else
		out.println("Your browser didn't identify itself.");
	    out.println("You accessed " + path + 
			"\nusing the " + method + " method");
	    out.println("The server is named "
			+ getServer().getAddress().getHostName()
			+ " (or "
			+ InetAddress.getLocalHost().getHostName()
			+ ")\nand is listening to port "
			+ getServer().getListeningPort());
	}
    }
}
