
import netscape.server.applet.HttpApplet;
import netscape.server.applet.Misconfiguration;

import java.io.File;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Random;
import java.lang.Math;

/**
 * This class is very similar to the random class, except it produces an 
 * image itself, not an HTML document. It randomly selects an image to return
 * from a directory you specify. It demonstrates how to return a file to
 * the browser, with proper content-length and last-modified headers.
 * 
 * This script takes one parameter, vpath, which specifies the virtual path
 * to a directory full of images to select from. A virtual path is simply a 
 * URL without the http://hostname part. 
 *
 * Caveat: This script assumes the images are all JPEGs
 * 
 * Rob McCool
 */
class RandomApplet2 extends HttpApplet {
    static int lastrand = 0;

    public void run() throws Exception {
        String vpath = getConfigProperty("vpath");
        String filename;
        Random rng;
        File fb;
        String files[];
        int x;

        // If there was no vpath given, try to find one from path info.
        if(vpath == null) {
            vpath = getServerProperty("path-info");
            if(vpath == null) {
                if (returnNormalResponse("text/html")) {
                    PrintStream out = getOutputStream();
                    out.print(usage);
                    return;
                }
            }
        }
        String dirpath = translateURI(vpath);
        File dir = new File(dirpath);

        // I keep the last generated random number around, because the 
        // Random class uses the current time as a seed. If I didn't do this,
        // you could press reload too fast and see the same picture a lot.
        if(lastrand == 0)
            rng = new Random();
        else
            rng = new Random(lastrand);

        // See if the given path exists, and is a directory. If an IO error
        // occurs, return a REQ_ABORTED which will cause the server to report
        // a server error to the client.
        if(dir.isDirectory() == false) {
            throw new Misconfiguration("the given image path " + dirpath + 
				       "is not a directory");
        }
        files = dir.list();

        // Return the page to the client.
	lastrand = rng.nextInt();
	x = Math.abs(lastrand % files.length);
	filename = dirpath + "/" + files[x];
	fb = new File(filename);
	if (!fb.exists()) {
	    throw new Misconfiguration(filename + " not found");
	}
	returnFile(fb);
    }
    static private String usage =
        "<html><title>Randomizer</title><H1>Randomizer</h1>" +
        "Usage error: You must provide a virtual path to the images you want "+
        "to select from as path information. For example, access<p>" +
        "<b><a href=/server-java/RandomApplet2/ns-icons>" +
        "/server-java/RandomApplet2/ns-icons</a></b><p>" +
        "<b>If you receive document contains no data errors, turn off your " +
        "browser's memory and disk caches</b>." +
        "</html>";
}
