/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * http.h: Deals with HTTP-related issues
 * 
 * Rob McCool
 */


#ifndef HTTP_H
#define HTTP_H


#include "netsite.h"
#include "base/session.h"
#include "base/pblock.h"

#include "frame/req.h"               /* REQ_MAX_LINE, Request structure */

/* ------------------------------ Constants ------------------------------- */


#define HTTP_DATE_LEN 128
#ifdef XP_UNIX
#define HTTP_DATE_FMT "%A, %d-%b-%y %T GMT"
#else /* XP_WIN32 */
#define HTTP_DATE_FMT "%A, %d-%b-%y %H:%M:%S GMT"
#endif /* XP_WIN32 */

/* Number of seconds to allow a second request to come over a persistent
   connection, zero to disable */
#ifdef MCC_PROXY
#define HTTP_DEFAULT_KEEPALIVE_TIMEOUT 5
#else
#define HTTP_DEFAULT_KEEPALIVE_TIMEOUT 15
#endif

/* The maximum number of RFC-822 headers we'll allow */
/* This would be smaller if a certain browser wasn't so damn stupid. */
#define HTTP_MAX_HEADERS 200


/* HTTP status codes */

#define PROTOCOL_OK 200
#define PROTOCOL_CREATED 201
#define PROTOCOL_NO_RESPONSE 204
#define PROTOCOL_PARTIAL_CONTENT 206
#define PROTOCOL_REDIRECT 302
#define PROTOCOL_NOT_MODIFIED 304
#define PROTOCOL_BAD_REQUEST 400
#define PROTOCOL_UNAUTHORIZED 401
#define PROTOCOL_FORBIDDEN 403
#define PROTOCOL_NOT_FOUND 404
#define PROTOCOL_PROXY_UNAUTHORIZED 407
#define PROTOCOL_SERVER_ERROR 500
#define PROTOCOL_NOT_IMPLEMENTED 501


#ifdef NET_SSL
#define HTTPS_PORT 443
#define HTTPS_URL "https"
#endif
#define HTTP_PORT 80
#define HTTP_URL "http"

/* -------------------------- http_scan_headers --------------------------- */


/*
 * gets the first line of an HTTP request
 */
#define protocol_find_request http_find_request
NSAPI_PUBLIC Request *http_find_request(netbuf *buf, Session *sn, int *reply);

/*
 * parses the first line of an HTTP request
 */

#define protocol_parse_request http_parse_request
NSAPI_PUBLIC int http_parse_request(char *t, Request *rq, Session *sn);

/*
 * Scans HTTP headers from the given netbuf, and places them in headers.
 * If netbuf is NULL, the session's inbuf is used.
 * 
 * Folded lines are joined and the linefeed removed (but not the whitespace).
 * If there are any repeat headers they are joined and the two field bodies
 * separated by a comma and space.
 *
 * t should be a string of length REQ_MAX_LINE. This is a convenience to
 * req.c so that we don't use too much runtime stack.
 *
 * Session is an optional parameter. Use NULL if you wish. It's used for
 * error logs.
 */

#define protocol_scan_headers http_scan_headers
NSAPI_PUBLIC int http_scan_headers(Session *sn, netbuf *buf, char *t, 
                                   pblock *headers);


/*
 * Starts the HTTP response. If HTTP/0.9, does nothing. If 1.0, sends header.
 * If this returns REQ_NOACTION, the method was head and no body should be
 * sent. Otherwise, it will return REQ_PROCEED.
 */

#define protocol_start_response http_start_response
NSAPI_PUBLIC int http_start_response(Session *sn, Request *rq);


/*
 * http_hdrs2env takes the entries from the given pblock and converts them
 * to an environment. 
 *
 * Each name entry will be made uppercase, prefixed with HTTP_ and any
 * occurrence of - will be converted to _.
 */

NSAPI_PUBLIC char **http_hdrs2env(pblock *pb);


/*
 * http_status sets status to the code n, with reason string r. If r is
 * NULL, the server will attempt to find one for the given status code.
 * If it finds none, it will give "Because I felt like it."
 */

#define protocol_status http_status
NSAPI_PUBLIC void http_status(Session *sn, Request *rq, int n, char *r);

/*
 * http_set_finfo sets content-length and last-modified
 */

#define protocol_set_finfo http_set_finfo
NSAPI_PUBLIC int http_set_finfo(Session *sn, Request *rq, struct stat *finfo);


/*
 * Takes the given pblock and prints headers into the given buffer at 
 * position pos. Returns the buffer, reallocated if needed. Modifies pos.
 */

NSAPI_PUBLIC char *http_dump822(pblock *pb, char *t, int *pos, int tsz);

/*
 * Finishes a request. For HTTP, this just closes the socket.
 */

#define protocol_finish_request http_finish_request
NSAPI_PUBLIC void http_finish_request(Session *sn, Request *rq);


/*
 * http_handle_session processes each request generated by Session
 */

#define protocol_handle_session http_handle_session
NSAPI_PUBLIC void http_handle_session(Session *sn);

/*
 * http_uri2url takes the give URI prefix and URI suffix and creates a 
 * newly-allocated full URL from them of the form
 * http://(server):(port)(prefix)(suffix)
 * 
 * If you want either prefix or suffix to be skipped, use "" instead of NULL.
 *
 * Normally, the server hostname is taken from the ServerName parameter in
 * magnus.conf. The newer function http_uri2url_dynamic should be used when 
 * a Session and Request structure are available, to ensure that the browser
 * gets redirected to the exact host they were originally referencing.
 */

#define protocol_uri2url http_uri2url
#define protocol_uri2url_dynamic http_uri2url_dynamic
NSAPI_PUBLIC char *http_uri2url(char *prefix, char *suffix);
NSAPI_PUBLIC char *http_uri2url_dynamic(char *prefix, char *suffix,
                                        Session *sn, Request *rq);

/*
 * http_set_keepalive_timeout sets the number of seconds to wait for a new
 * request to come from a persistent connection. Returns nothing. Intended
 * to be called at server startup only.
 *
 * Specifying a timeout of zero will disable persistent connections and allow
 * browsers to request only one file per connection.
 */
#define protocol_set_keepalive_timeout http_set_keepalive_timeout
NSAPI_PUBLIC void http_set_keepalive_timeout(int secs);

#endif
