/* $NetBSD: omap3_usbtllreg.h,v 1.2 2014/03/29 23:32:41 matt Exp $ */

/*-
 * Copyright (c) 2010 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _OMAP3_USBTLLREG_H
#define _OMAP3_USBTLLREG_H

/* 32-bit */
#define	USBTLL_REVISION		0x00
#define	 USBTLL_REVISION_MAJOR(x)	(((x) >> 4) & 0xf)
#define	 USBTLL_REVISION_MINOR(x)	((x) & 0xf)

#define USBTLL_HWINFO		0x04
#define  USBTLL_HWINFO_SAR_CNTX_SIZE	__BITS(7,0)

#define	USBTLL_SYSCONFIG	0x10
#define	 USBTLL_SYSCONFIG_CLOCKACTIVITY	0x00000100
#define	 USBTLL_SYSCONFIG_SIDLEMODE	0x00000018
#define	 USBTLL_SYSCONFIG_ENAWAKEUP	0x00000004
#define	 USBTLL_SYSCONFIG_SOFTRESET	0x00000002
#define	 USBTLL_SYSCONFIG_AUTOIDLE	0x00000001

#define	USBTLL_SYSSTATUS	0x14
#define	 USBTLL_SYSSTATUS_RESETDONE	0x00000001

#define	USBTLL_IRQSTATUS	0x18
#define	 USBTLL_IRQSTATUS_ACCESS_ERROR	0x00000004
#define	 USBTLL_IRQSTATUS_FCLK_END	0x00000002
#define	 USBTLL_IRQSTATUS_FCLK_START	0x00000001

#define	USBTLL_IRQENABLE	0x1c
#define	 USBTLL_IRQENABLE_ACCESS_ERROR_EN	0x00000004
#define	 USBTLL_IRQENABLE_FCLK_END_EN		0x00000002
#define	 USBTLL_IRQENABLE_FCLK_START_EN		0x00000001

#define	USBTLL_SHARED_CONF	0x30
#define	 USBTLL_SHARED_CONF_USB_90D_DDR_EN	0x00000040
#define	 USBTLL_SHARED_CONF_USB_180D_SDR_EN	0x00000020
#define	 USBTLL_SHARED_CONF_USB_DIVRATIO	0x0000001c
#define	 USBTLL_SHARED_CONF_FCLK_REQ		0x00000002
#define	 USBTLL_SHARED_CONF_FCLK_IS_ON		0x00000001

#define	USBTLL_CHANNEL_CONF(i)	(0x40 + (0x04 * (i)))
#define	 USBTLL_CHANNEL_CONF_FSLSLINESTATE	0x30000000
#define	 USBTLL_CHANNEL_CONF_FSLSMODE		0x0f000000
#define	 USBTLL_CHANNEL_CONF_TESTTXSE0		0x00100000
#define	 USBTLL_CHANNEL_CONF_TESTTXDAT		0x00080000
#define	 USBTLL_CHANNEL_CONF_TESTTXEN		0x00040000
#define	 USBTLL_CHANNEL_CONF_TESTEN		0x00020000
#define	 USBTLL_CHANNEL_CONF_DRVVBUS		0x00010000
#define	 USBTLL_CHANNEL_CONF_CHRGVBUS		0x00008000
#define	 USBTLL_CHANNEL_CONF_ULPINOBITSTUFF	0x00000800
#define	 USBTLL_CHANNEL_CONF_ULPIAUTOIDLE	0x00000400
#define	 USBTLL_CHANNEL_CONF_UTMIAUTOIDLE	0x00000200
#define	 USBTLL_CHANNEL_CONF_ULPIDDRMODE	0x00000100
#define	 USBTLL_CHANNEL_CONF_ULPIOUTCLKMODE	0x00000080
#define	 USBTLL_CHANNEL_CONF_TLLFULLSPEED	0x00000040
#define	 USBTLL_CHANNEL_CONF_TLLCONNECT		0x00000020
#define	 USBTLL_CHANNEL_CONF_TLLATTACH		0x00000010
#define	 USBTLL_CHANNEL_CONF_UTMIISADEV		0x00000008
#define	 USBTLL_CHANNEL_CONF_CHANMODE		0x00000006
#define	 USBTLL_CHANNEL_CONF_CHANEN		0x00000001

#define USBTLL_SAR_CNTX(i)	(0x400 + (0x04 * (i)))

/* 8-bit */
#define	ULPI_VENDOR_ID_LO(i)	(0x100 * (i) + 0)
#define	ULPI_VENDOR_ID_HI(i)	(0x100 * (i) + 1)
#define	ULPI_PRODUCT_ID_LO(i)	(0x100 * (i) + 2)
#define	ULPI_PRODUCT_ID_HI(i)	(0x100 * (i) + 3)

#define	ULPI_FUNCTION_CTRL(i)	(0x100 * (i) + 4)
#define	ULPI_FUNCTION_CTRL_SET(i) (0x100 * (i) + 5)
#define	ULPI_FUNCTION_CTRL_CLR(i) (0x100 * (i) + 6)
#define	 ULPI_FUNCTION_CTRL_SUSPENDM	0x40
#define	 ULPI_FUNCTION_CTRL_RESET	0x20
#define	 ULPI_FUNCTION_CTRL_OPMODE	0x18
#define	 ULPI_FUNCTION_CTRL_TERMSELECT	0x04
#define	 ULPI_FUNCTION_CTRL_XCVRSELECT	0x03

#define	ULPI_INTERFACE_CTRL(i)	(0x100 * (i) + 7)
#define	ULPI_INTERFACE_CTRL_SET(i) (0x100 * (i) + 8)
#define	ULPI_INTERFACE_CTRL_CLR(i) (0x100 * (i) + 9)
#define	 ULPI_INTERFACE_CTRL_INTERFACE_PROTECT_DISABLE	0x80
#define	 ULPI_INTERFACE_CTRL_AUTORESUME			0x10
#define	 ULPI_INTERFACE_CTRL_CLOCKSUSPENDM		0x08
#define	 ULPI_INTERFACE_CTRL_FSLSSERIALMODE_3PIN	0x02
#define	 ULPI_INTERFACE_CTRL_FSLSSERIALMODE_6PIN	0x01

#define	ULPI_OTG_CTRL(i)	(0x100 * (i) + 10)
#define	ULPI_OTG_CTRL_SET(i)	(0x100 * (i) + 11)
#define	ULPI_OTG_CTRL_CLR(i)	(0x100 * (i) + 12)
#define	 ULPI_OTG_CTRL_DRVVBUS		0x20
#define	 ULPI_OTG_CTRL_CHRGVBUS		0x10
#define	 ULPI_OTG_CTRL_DISCHRGVBUS	0x08
#define	 ULPI_OTG_CTRL_DMPULLDOWN	0x04
#define	 ULPI_OTG_CTRL_DPPULLDOWN	0x02
#define	 ULPI_OTG_CTRL_IDPULLUP		0x01

#define	ULPI_USB_INT_EN_RISE(i)		(0x100 * (i) + 13)
#define	ULPI_USB_INT_EN_RISE_SET(i)	(0x100 * (i) + 14)
#define	ULPI_USB_INT_EN_RISE_CLR(i)	(0x100 * (i) + 15)
#define	ULPI_USB_INT_EN_FALL(i)		(0x100 * (i) + 16)
#define	ULPI_USB_INT_EN_FALL_SET(i)	(0x100 * (i) + 17)
#define	ULPI_USB_INT_EN_FALL_CLR(i)	(0x100 * (i) + 18)
#define	ULPI_USB_INT_STATUS(i)		(0x100 * (i) + 19)
#define	ULPI_USB_INT_LATCH(i)		(0x100 * (i) + 20)
#define	 ULPI_USB_INT_IDGND			0x10
#define	 ULPI_USB_INT_SESSEND			0x08
#define	 ULPI_USB_INT_SESSVALID			0x04
#define	 ULPI_USB_INT_VBUSVALID			0x02
#define	 ULPI_USB_INT_HOSTDISCONNECT		0x01

#define	ULPI_DEBUG(i)			(0x100 * (i) + 21)
#define	 ULPI_DEBUG_LINESTATE		0x03

#define	ULPI_SCRATCH_REGISTER(i)	(0x100 * (i) + 22)
#define	ULPI_SCRATCH_REGISTER_SET(i)	(0x100 * (i) + 23)
#define	ULPI_SCRATCH_REGISTER_CLR(i)	(0x100 * (i) + 24)

#define	ULPI_EXTENDED_SET_ACCESS(i)	(0x100 * (i) + 47)

#define	ULPI_UTMI_VCONTROL_EN(i)	(0x100 * (i) + 48)
#define	ULPI_UTMI_VCONTROL_EN_SET(i)	(0x100 * (i) + 49)
#define	ULPI_UTMI_VCONTROL_EN_CLR(i)	(0x100 * (i) + 50)
#define	ULPI_UTMI_VCONTROL_STATUS(i)	(0x100 * (i) + 51)
#define	ULPI_UTMI_VCONTROL_LATCH(i)	(0x100 * (i) + 52)
#define	 ULPI_UTMI_VC(n)		 (1 << (n))

#define	ULPI_UTMI_VSTATUS(i)		(0x100 * (i) + 53)
#define	ULPI_UTMI_VSTATUS_SET(i)	(0x100 * (i) + 54)
#define	ULPI_UTMI_VSTATUS_CLR(i)	(0x100 * (i) + 55)

#define	ULPI_USB_INT_LATCH_NOCLR(i)	(0x100 * (i) + 56)
 /* use ULPI_USB_INT_* */

#define	ULPI_VENDOR_INT_EN(i)		(0x100 * (i) + 59)
#define	ULPI_VENDOR_INT_EN_SET(i)	(0x100 * (i) + 60)
#define	ULPI_VENDOR_INT_EN_CLR(i)	(0x100 * (i) + 61)
#define	 ULPI_VENDOR_INT_EN_P2P_EN	0x01

#define	ULPI_VENDOR_INT_STATUS(i)	(0x100 * (i) + 62)
#define	 ULPI_VENDOR_INT_STATUS_UTMI_SUSPENDM	0x01

#define	ULPI_VENDOR_INT_LATCH(i)	(0x100 * (i) + 62)
#define	 ULPI_VENDOR_INT_STATUS_P2P_LATCH	0x01

#endif /* !_OMAP3_USBTLLREG_H */
