/*	$NetBSD: ast_dram_tables.h,v 1.2 2018/08/27 04:58:23 riastradh Exp $	*/

#ifndef AST_DRAM_TABLES_H
#define AST_DRAM_TABLES_H

/* DRAM timing tables */
struct ast_dramstruct {
	u16 index;
	u32 data;
};

static const struct ast_dramstruct ast2000_dram_table_data[] = {
	{ 0x0108, 0x00000000 },
	{ 0x0120, 0x00004a21 },
	{ 0xFF00, 0x00000043 },
	{ 0x0000, 0xFFFFFFFF },
	{ 0x0004, 0x00000089 },
	{ 0x0008, 0x22331353 },
	{ 0x000C, 0x0d07000b },
	{ 0x0010, 0x11113333 },
	{ 0x0020, 0x00110350 },
	{ 0x0028, 0x1e0828f0 },
	{ 0x0024, 0x00000001 },
	{ 0x001C, 0x00000000 },
	{ 0x0014, 0x00000003 },
	{ 0xFF00, 0x00000043 },
	{ 0x0018, 0x00000131 },
	{ 0x0014, 0x00000001 },
	{ 0xFF00, 0x00000043 },
	{ 0x0018, 0x00000031 },
	{ 0x0014, 0x00000001 },
	{ 0xFF00, 0x00000043 },
	{ 0x0028, 0x1e0828f1 },
	{ 0x0024, 0x00000003 },
	{ 0x002C, 0x1f0f28fb },
	{ 0x0030, 0xFFFFFE01 },
	{ 0xFFFF, 0xFFFFFFFF }
};

static const struct ast_dramstruct ast1100_dram_table_data[] = {
	{ 0x2000, 0x1688a8a8 },
	{ 0x2020, 0x000041f0 },
	{ 0xFF00, 0x00000043 },
	{ 0x0000, 0xfc600309 },
	{ 0x006C, 0x00909090 },
	{ 0x0064, 0x00050000 },
	{ 0x0004, 0x00000585 },
	{ 0x0008, 0x0011030f },
	{ 0x0010, 0x22201724 },
	{ 0x0018, 0x1e29011a },
	{ 0x0020, 0x00c82222 },
	{ 0x0014, 0x01001523 },
	{ 0x001C, 0x1024010d },
	{ 0x0024, 0x00cb2522 },
	{ 0x0038, 0xffffff82 },
	{ 0x003C, 0x00000000 },
	{ 0x0040, 0x00000000 },
	{ 0x0044, 0x00000000 },
	{ 0x0048, 0x00000000 },
	{ 0x004C, 0x00000000 },
	{ 0x0050, 0x00000000 },
	{ 0x0054, 0x00000000 },
	{ 0x0058, 0x00000000 },
	{ 0x005C, 0x00000000 },
	{ 0x0060, 0x032aa02a },
	{ 0x0064, 0x002d3000 },
	{ 0x0068, 0x00000000 },
	{ 0x0070, 0x00000000 },
	{ 0x0074, 0x00000000 },
	{ 0x0078, 0x00000000 },
	{ 0x007C, 0x00000000 },
	{ 0x0034, 0x00000001 },
	{ 0xFF00, 0x00000043 },
	{ 0x002C, 0x00000732 },
	{ 0x0030, 0x00000040 },
	{ 0x0028, 0x00000005 },
	{ 0x0028, 0x00000007 },
	{ 0x0028, 0x00000003 },
	{ 0x0028, 0x00000001 },
	{ 0x000C, 0x00005a08 },
	{ 0x002C, 0x00000632 },
	{ 0x0028, 0x00000001 },
	{ 0x0030, 0x000003c0 },
	{ 0x0028, 0x00000003 },
	{ 0x0030, 0x00000040 },
	{ 0x0028, 0x00000003 },
	{ 0x000C, 0x00005a21 },
	{ 0x0034, 0x00007c03 },
	{ 0x0120, 0x00004c41 },
	{ 0xffff, 0xffffffff },
};

static const struct ast_dramstruct ast2100_dram_table_data[] = {
	{ 0x2000, 0x1688a8a8 },
	{ 0x2020, 0x00004120 },
	{ 0xFF00, 0x00000043 },
	{ 0x0000, 0xfc600309 },
	{ 0x006C, 0x00909090 },
	{ 0x0064, 0x00070000 },
	{ 0x0004, 0x00000489 },
	{ 0x0008, 0x0011030f },
	{ 0x0010, 0x32302926 },
	{ 0x0018, 0x274c0122 },
	{ 0x0020, 0x00ce2222 },
	{ 0x0014, 0x01001523 },
	{ 0x001C, 0x1024010d },
	{ 0x0024, 0x00cb2522 },
	{ 0x0038, 0xffffff82 },
	{ 0x003C, 0x00000000 },
	{ 0x0040, 0x00000000 },
	{ 0x0044, 0x00000000 },
	{ 0x0048, 0x00000000 },
	{ 0x004C, 0x00000000 },
	{ 0x0050, 0x00000000 },
	{ 0x0054, 0x00000000 },
	{ 0x0058, 0x00000000 },
	{ 0x005C, 0x00000000 },
	{ 0x0060, 0x0f2aa02a },
	{ 0x0064, 0x003f3005 },
	{ 0x0068, 0x02020202 },
	{ 0x0070, 0x00000000 },
	{ 0x0074, 0x00000000 },
	{ 0x0078, 0x00000000 },
	{ 0x007C, 0x00000000 },
	{ 0x0034, 0x00000001 },
	{ 0xFF00, 0x00000043 },
	{ 0x002C, 0x00000942 },
	{ 0x0030, 0x00000040 },
	{ 0x0028, 0x00000005 },
	{ 0x0028, 0x00000007 },
	{ 0x0028, 0x00000003 },
	{ 0x0028, 0x00000001 },
	{ 0x000C, 0x00005a08 },
	{ 0x002C, 0x00000842 },
	{ 0x0028, 0x00000001 },
	{ 0x0030, 0x000003c0 },
	{ 0x0028, 0x00000003 },
	{ 0x0030, 0x00000040 },
	{ 0x0028, 0x00000003 },
	{ 0x000C, 0x00005a21 },
	{ 0x0034, 0x00007c03 },
	{ 0x0120, 0x00005061 },
	{ 0xffff, 0xffffffff },
};

#endif
