.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtGet-Resource-List XtGet-Constraint-Resource-List wid-get
.na
.TH XtGetResourceList __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtGetResourceList, XtGetConstraintResourceList \- obtain resource list
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtGetResourceList(WidgetClass \fIclass\fP, XtResourceList
*\fIresources_return\fP, Cardinal *\fInum_resources_return\fP);
.HP
void XtGetConstraintResourceList(WidgetClass \fIclass\fP, XtResourceList
*\fIresources_return\fP, Cardinal *\fInum_resources_return\fP);
.SH ARGUMENTS
.IP \fInum_resources_return\fP 1i
Specifies a pointer to where to store the number of entries in the
resource list.
.IP \fIresources_return\fP 1i
Specifies a pointer to where to store the returned resource list.
The caller must free this storage using
.B XtFree
when done with it.
.IP \fIwidget_class\fP 1i
Specifies the widget class for which you want the list.
.SH DESCRIPTION
If
.B XtGetResourceList
is called before the widget class is initialized (that is,
before the first widget of that class has been created),
.B XtGetResourceList
returns the resource list as specified in the widget class record.
If it is called after the widget class has been initialized,
.B XtGetResourceList
returns a merged resource list that contains the resources
for all superclasses.
The list returned by
.B XtGetResourceList
should be freed using
.B XtFree
when it is no longer needed.
.LP
If
.B XtGetConstraintResourceList
is called before the widget class is initialized (that is,
before the first widget of that class has been created),
.B XtGetConstraintResourceList
returns the resource list as specified in the widget class Constraint
part record.
If it is called after the widget class has been initialized,
.B XtGetConstraintResourceList
returns a merged resource list that contains the Constraint resources
for all superclasses.
If the specified class is not a subclass of
.BR constraintWidgetClass ,
\fI*resources_return\fP is set to NULL and \fI*num_resources_return\fP
is set to zero.
The list returned by
.B XtGetConstraintResourceList
should be freed using
.B XtFree
when it is no longer needed.
.SH "SEE ALSO"
XtGetSubresources(__libmansuffix__),
XtOffset(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
