/* $NetBSD: tegra_ahcisatareg.h,v 1.3 2018/12/14 12:29:22 skrll Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_TEGRA_AHCISATAREG_H
#define _ARM_TEGRA_AHCISATAREG_H

#define TEGRA_SATA_FPCI_BAR5_REG		0x94

#define TEGRA_SATA_FPCI_BAR_START			__BITS(31,4)
#define TEGRA_SATA_FPCI_BAR_ACCESS_TYPE			__BIT(0)

#define TEGRA_SATA_CONFIGURATION_REG		0x180
#define TEGRA_SATA_CONFIGURATION_CLKEN_OVERRIDE		__BIT(31)
#define TEGRA_SATA_CONFIGURATION_EN_FPCI		__BIT(0)

#define TEGRA_SATA_INTR_MASK_REG		0x188
#define TEGRA_SATA_INTR_MASK_IP_INT			__BIT(16)
#define TEGRA_SATA_INTR_MASK_MSI			__BIT(8)
#define TEGRA_SATA_INTR_MASK_INT			__BIT(0)

#define TEGRA_T_SATA0_CFG1_REG			0x1004
#define TEGRA_T_SATA0_CFG1_INTR_DISABLE			__BIT(10)
#define TEGRA_T_SATA0_CFG1_SERR				__BIT(8)
#define TEGRA_T_SATA0_CFG1_BUS_MASTER			__BIT(2)
#define TEGRA_T_SATA0_CFG1_MEM_SPACE			__BIT(1)
#define TEGRA_T_SATA0_CFG1_IO_SPACE			__BIT(0)


#define TEGRA_T_SATA0_CFG9_REG			0x1024
#define TEGRA_T_SATA0_CFG9_BASE_ADDRESS			__BITS(31,13)
#define TEGRA_T_SATA0_CFG9_SPACE_TYPE			__BIT(0)

#define TEGRA_SATA_AUX_MISC_CNTL_1_REG		0x1108
#define TEGRA_SATA_AUX_MISC_CNTL_1_AUX_OR_CORE_IDLE_STATUS_SEL	__BIT(18)
#define TEGRA_SATA_AUX_MISC_CNTL_1_SDS_SUPPORT		__BIT(13)
#define TEGRA_SATA_AUX_MISC_CNTL_1_OOB_ON_POR		__BIT(7)

#define TEGRA_SATA_AUX_RX_STAT_INT_REG		0x110c
#define TEGRA_SATA_AUX_RX_STAT_INT_SATA_RX_STAT_INT_DISABLE	__BIT(2)

#define TEGRA_T_SATA0_NVOOB_REG			0x1114
#define  TEGRA_T_SATA0_NVOOB_COMMA_CNT			__BITS(30,28)
#define  TEGRA_T_SATA0_NVOOB_SQUELCH_FILTER_LENGTH	__BITS(27,26)
#define  TEGRA_T_SATA0_NVOOB_SQUELCH_FILTER_MODE	__BITS(25,24)

#define TEGRA_T_SATA0_CFG_PHY_0_REG		0x1120
#define  TEGRA_T_SATA0_CFG_PHY_0_MASK_SQUELCH			__BIT(24)
#define  TEGRA_T_SATA0_CFG_PHY_0_USE_7BIT_ALIGN_DET_FOR_SPD	__BIT(11)

#define TEGRA_T_SATA0_CFG_PHY_1_REG		0x112c
#define  TEGRA_T_SATA0_CFG_PHY_1_PADS_IDDQ_EN		__BIT(23)
#define  TEGRA_T_SATA0_CFG_PHY_1_PAD_PLL_IDDQ_EN	__BIT(22)

#define TEGRA_T_SATA0_CFG_2NVOOB_2_REG		0x1134
#define  TEGRA_T_SATA0_CFG_2NVOOB_2_COMWAKE_IDLE_CNT_LOW	__BITS(26,18)

#define TEGRA_T_SATA0_AHCI_HBA_CAP_BKDR_REG	0x1300
#define TEGRA_T_SATA0_AHCI_HBA_CAP_BKDR_SALP		__BIT(26)
#define TEGRA_T_SATA0_AHCI_HBA_CAP_BKDR_SUPP_PM		__BIT(17)
#define	TEGRA_T_SATA0_AHCI_HBA_CAP_BKDR_SLUMBER_ST_CAP	__BIT(14)
#define	TEGRA_T_SATA0_AHCI_HBA_CAP_BKDR_PARTIAL_ST_CAP	__BIT(13)

#define TEGRA_T_SATA0_BKDOOR_CC_REG		0x14a4
#define TEGRA_T_SATA0_BKDOOR_CC_CLASS_CODE		__BITS(31,16)
#define TEGRA_T_SATA0_BKDOOR_CC_PROG_IF			__BITS(15,8)

#define TEGRA_T_SATA0_CFG_POWER_GATE_REG	0x14ac
#define TEGRA_T_SATA0_CFG_POWER_GATE_SSTS_RESTORED	__BIT(23)

#define TEGRA_T_SATA0_CFG_SATA_REG		0x154c
#define TEGRA_T_SATA0_CFG_SATA_BACKDOOR_PROG_IF_EN	__BIT(12)

#define TEGRA_T_SATA0_INDEX_REG			0x1680
#define TEGRA_T_SATA0_INDEX_CH4				__BIT(3)
#define TEGRA_T_SATA0_INDEX_CH3				__BIT(2)
#define TEGRA_T_SATA0_INDEX_CH2				__BIT(1)
#define TEGRA_T_SATA0_INDEX_CH1				__BIT(0)

#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN1_REG	0x1690
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN1_TX_DRV_CNTL	__BITS(27,24)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN1_TX_PEAK_PRE	__BITS(23,20)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN1_TX_CMADJ	__BITS(19,16)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN1_TX_PEAK	__BITS(15,8)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN1_TX_AMP		__BITS(7,0)

#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN2_REG	0x1694
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN2_TX_DRV_CNTL	__BITS(27,24)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN2_TX_PEAK_PRE	__BITS(23,20)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN2_TX_PEAK	__BITS(19,12)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN2_TX_CMADJ	__BITS(11,8)
#define TEGRA_T_SATA0_CHX_PHY_CTRL1_GEN2_TX_AMP		__BITS(7,0)

#define TEGRA_T_SATA0_CHX_PHY_CTRL2_REG		0x169c
#define TEGRA_T_SATA0_CHX_PHY_CTRL2_CDR_CNTL_GEN3	__BITS(23,16)
#define TEGRA_T_SATA0_CHX_PHY_CTRL2_CDR_CNTL_GEN2	__BITS(15,8)
#define TEGRA_T_SATA0_CHX_PHY_CTRL2_CDR_CNTL_GEN1	__BITS(7,0)

#define TEGRA_T_SATA0_CHX_PHY_CTRL11_REG	0x16d0
#define TEGRA_T_SATA0_CHX_PHY_CTRL11_GEN2_RX_EQ		__BITS(31,16)
#define TEGRA_T_SATA0_CHX_PHY_CTRL11_GEN1_RX_EQ		__BITS(15,0)

#define	TEGRA_T_SATA0_CHX_PHY_CTRL17_REG	0x16e8
#define	TEGRA_T_SATA0_CHX_PHY_CTRL18_REG	0x16ec
#define	TEGRA_T_SATA0_CHX_PHY_CTRL19_REG	0x16f0
#define	TEGRA_T_SATA0_CHX_PHY_CTRL20_REG	0x16f4
#define	TEGRA_T_SATA0_CHX_PHY_CTRL21_REG	0x16f8

#endif /* _ARM_TEGRA_AHCISATAREG_H */
