/*	$NetBSD: authorityKeyIdentifier.c,v 1.2 2021/08/14 16:14:51 christos Exp $	*/

/*
 *    authorityKeyIdentifier.c
 *    "AuthorityKeyIdentifierDefinition" ASN.1 module encode/decode/extracting/matching/free C src.
 *    This file was generated by modified eSMACC compiler Wed Dec  8 22:22:49 2004
 *    The generated files are supposed to be compiled as a module for OpenLDAP Software
 */

#include "authorityKeyIdentifier.h"

BDecComponentAuthorityKeyIdentifierTop( void* mem_op, GenBuf* b, void *v, AsnLen* bytesDecoded,int mode) {
	AsnTag tag;
	AsnLen elmtLen;

	tag = BDecTag ( b, bytesDecoded );
	elmtLen = BDecLen ( b, bytesDecoded );
	if ( elmtLen <= 0 ) return (-1);
	if ( tag != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE) ) {
		return (-1);
	}
		
	return BDecComponentAuthorityKeyIdentifier( mem_op, b, tag, elmtLen, ( ComponentAuthorityKeyIdentifier**)v, (AsnLen*)bytesDecoded, mode );
}


void init_module_AuthorityKeyIdentifierDefinition() {
	InstallOidDecoderMapping( "2.5.29.35", NULL,
				GDecComponentAuthorityKeyIdentifier,
				BDecComponentAuthorityKeyIdentifierTop,
				ExtractingComponentAuthorityKeyIdentifier,
				MatchingComponentAuthorityKeyIdentifier	);
}

int
MatchingComponentOtherName ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentOid ( oid, (ComponentSyntaxInfo*)&((ComponentOtherName*)csi_attr)->type_id, (ComponentSyntaxInfo*)&((ComponentOtherName*)csi_assert)->type_id );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	SetAnyTypeByComponentOid ((ComponentSyntaxInfo*)&((ComponentOtherName*)csi_attr)->value, (&((ComponentOtherName*)csi_attr)->type_id));
	rc = MatchingComponentAnyDefinedBy ( oid, (ComponentAny*)&((ComponentOtherName*)csi_attr)->value, (ComponentAny*)&((ComponentOtherName*)csi_assert)->value);
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentOtherName */

void*
ExtractingComponentOtherName ( void* mem_op, ComponentReference* cr, ComponentOtherName *comp )
{

	if ( ( comp->type_id.identifier.bv_val && strncmp(comp->type_id.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->type_id.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->type_id;
		else
		return NULL;
	}
	if ( ( comp->value.identifier.bv_val && strncmp(comp->value.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->value.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->value;
		else
		return NULL;
	}
	return NULL;
}  /* ExtractingComponentOtherName */

int
BDecComponentOtherName PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentOtherName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	int old_mode = mode;
	int rc;
	ComponentOtherName *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
		rc = 	BDecComponentOid (mem_op, b, tagId1, elmtLen1, (&k->type_id), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->type_id)->identifier.bv_val = (&k->type_id)->id_buf;
		(&k->type_id)->identifier.bv_len = strlen("type_id");
		strcpy( (&k->type_id)->identifier.bv_val, "type_id");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
		rc = SetAnyTypeByComponentOid ((&k->value), (&k->type_id));
 	rc = BDecComponentAnyDefinedBy (mem_op,b, (&k->value), &totalElmtsLen1, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->value)->identifier.bv_val = (&k->value)->id_buf;
		(&k->value)->identifier.bv_len = strlen("value");
		strcpy( (&k->value)->identifier.bv_val, "value");
	if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentOtherName*) CompAlloc( mem_op, sizeof(ComponentOtherName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentOtherName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentOtherName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentOtherName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentOtherName;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecOtherName*/

int
GDecComponentOtherName PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentOtherName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentOtherName *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "type_id", strlen("type_id") ) == 0 ) {
		rc = 	GDecComponentOid (mem_op, b, (&k->type_id), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->type_id)->identifier.bv_val = peek_head;
	(&k->type_id)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "value", strlen("value") ) == 0 ) {
		rc = SetAnyTypeByComponentOid ((&k->value), (&k->type_id));
	rc = GDecComponentAnyDefinedBy (mem_op, b, (&k->value), bytesDecoded, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->value)->identifier.bv_val = peek_head;
	(&k->value)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentOtherName*) CompAlloc( mem_op, sizeof(ComponentOtherName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentOtherName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentOtherName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentOtherName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentOtherName;
	return LDAP_SUCCESS;
}  /* GDecOtherName*/


int
MatchingComponentORAddress ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentOid ( oid, (ComponentSyntaxInfo*)&((ComponentORAddress*)csi_attr)->type_id, (ComponentSyntaxInfo*)&((ComponentORAddress*)csi_assert)->type_id );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	SetAnyTypeByComponentOid ((ComponentSyntaxInfo*)&((ComponentORAddress*)csi_attr)->value, (&((ComponentORAddress*)csi_attr)->type_id));
	rc = MatchingComponentAnyDefinedBy ( oid, (ComponentAny*)&((ComponentORAddress*)csi_attr)->value, (ComponentAny*)&((ComponentORAddress*)csi_assert)->value);
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentOcts ( oid, (ComponentSyntaxInfo*)&((ComponentORAddress*)csi_attr)->extension, (ComponentSyntaxInfo*)&((ComponentORAddress*)csi_assert)->extension );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentORAddress */

void*
ExtractingComponentORAddress ( void* mem_op, ComponentReference* cr, ComponentORAddress *comp )
{

	if ( ( comp->type_id.identifier.bv_val && strncmp(comp->type_id.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->type_id.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->type_id;
		else
		return NULL;
	}
	if ( ( comp->value.identifier.bv_val && strncmp(comp->value.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->value.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->value;
		else
		return NULL;
	}
	if ( ( comp->extension.identifier.bv_val && strncmp(comp->extension.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->extension.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->extension;
		else
		return NULL;
	}
	return NULL;
}  /* ExtractingComponentORAddress */

int
BDecComponentORAddress PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentORAddress **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentORAddress *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
		rc = 	BDecComponentOid (mem_op, b, tagId1, elmtLen1, (&k->type_id), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->type_id)->identifier.bv_val = (&k->type_id)->id_buf;
		(&k->type_id)->identifier.bv_len = strlen("type_id");
		strcpy( (&k->type_id)->identifier.bv_val, "type_id");
    }
    else
        return -1;



    {
		rc = SetAnyTypeByComponentOid ((&k->value), (&k->type_id));
 	rc = BDecComponentAnyDefinedBy (mem_op,b, (&k->value), &totalElmtsLen1, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->value)->identifier.bv_val = (&k->value)->id_buf;
		(&k->value)->identifier.bv_len = strlen("value");
		strcpy( (&k->value)->identifier.bv_val, "value");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OCTETSTRING_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, OCTETSTRING_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
		rc = 	BDecComponentOcts (mem_op, b, tagId1, elmtLen1, (&k->extension), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->extension)->identifier.bv_val = (&k->extension)->id_buf;
		(&k->extension)->identifier.bv_len = strlen("extension");
		strcpy( (&k->extension)->identifier.bv_val, "extension");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }


    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentORAddress*) CompAlloc( mem_op, sizeof(ComponentORAddress) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentORAddress ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentORAddress ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentORAddress;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentORAddress;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecORAddress*/

int
GDecComponentORAddress PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentORAddress **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentORAddress *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "type_id", strlen("type_id") ) == 0 ) {
		rc = 	GDecComponentOid (mem_op, b, (&k->type_id), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->type_id)->identifier.bv_val = peek_head;
	(&k->type_id)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "value", strlen("value") ) == 0 ) {
		rc = SetAnyTypeByComponentOid ((&k->value), (&k->type_id));
	rc = GDecComponentAnyDefinedBy (mem_op, b, (&k->value), bytesDecoded, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->value)->identifier.bv_val = peek_head;
	(&k->value)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "extension", strlen("extension") ) == 0 ) {
		rc = 	GDecComponentOcts (mem_op, b, (&k->extension), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->extension)->identifier.bv_val = peek_head;
	(&k->extension)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentORAddress*) CompAlloc( mem_op, sizeof(ComponentORAddress) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentORAddress ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentORAddress ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentORAddress;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentORAddress;
	return LDAP_SUCCESS;
}  /* GDecORAddress*/


int
MatchingComponentDirectoryString ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	ComponentDirectoryString *v1, *v2;


	v1 = (ComponentDirectoryString*)csi_attr;
	v2 = (ComponentDirectoryString*)csi_assert;
	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	if( (v1->choiceId != v2->choiceId ) )
		return LDAP_COMPARE_FALSE;
	switch( v1->choiceId )
	{
	   case DIRECTORYSTRING_TELETEXSTRING :
		rc = 	MatchingComponentTeletexString ( oid, (ComponentSyntaxInfo*)(v1->a.teletexString), (ComponentSyntaxInfo*)(v2->a.teletexString) );
		break;
	   case DIRECTORYSTRING_PRINTABLESTRING :
		rc = 	MatchingComponentPrintableString ( oid, (ComponentSyntaxInfo*)(v1->a.printableString), (ComponentSyntaxInfo*)(v2->a.printableString) );
		break;
	   case DIRECTORYSTRING_UNIVERSALSTRING :
		rc = 	MatchingComponentUniversalString ( oid, (ComponentSyntaxInfo*)(v1->a.universalString), (ComponentSyntaxInfo*)(v2->a.universalString) );
		break;
	   case DIRECTORYSTRING_UTF8STRING :
		rc = 	MatchingComponentUTF8String ( oid, (ComponentSyntaxInfo*)(v1->a.utf8String), (ComponentSyntaxInfo*)(v2->a.utf8String) );
		break;
	   case DIRECTORYSTRING_BMPSTRING :
		rc = 	MatchingComponentBMPString ( oid, (ComponentSyntaxInfo*)(v1->a.bmpString), (ComponentSyntaxInfo*)(v2->a.bmpString) );
		break;
	default : 
		 return LDAP_PROTOCOL_ERROR;
	}
	return rc;
}  /* BMatchingComponentDirectoryStringContent */

void*
ExtractingComponentDirectoryString ( void* mem_op, ComponentReference* cr, ComponentDirectoryString *comp )
{


	if( (comp->choiceId) ==  DIRECTORYSTRING_TELETEXSTRING &&
		 (( comp->a.teletexString->identifier.bv_val && strncmp(comp->a.teletexString->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.teletexString->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.teletexString);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTeletexString ( mem_op, cr, (comp->a.teletexString) );
		};
	}
	if( (comp->choiceId) ==  DIRECTORYSTRING_PRINTABLESTRING &&
		 (( comp->a.printableString->identifier.bv_val && strncmp(comp->a.printableString->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.printableString->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.printableString);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentPrintableString ( mem_op, cr, (comp->a.printableString) );
		};
	}
	if( (comp->choiceId) ==  DIRECTORYSTRING_UNIVERSALSTRING &&
		 (( comp->a.universalString->identifier.bv_val && strncmp(comp->a.universalString->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.universalString->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.universalString);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentUniversalString ( mem_op, cr, (comp->a.universalString) );
		};
	}
	if( (comp->choiceId) ==  DIRECTORYSTRING_UTF8STRING &&
		 (( comp->a.utf8String->identifier.bv_val && strncmp(comp->a.utf8String->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.utf8String->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.utf8String);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentUTF8String ( mem_op, cr, (comp->a.utf8String) );
		};
	}
	if( (comp->choiceId) ==  DIRECTORYSTRING_BMPSTRING &&
		 (( comp->a.bmpString->identifier.bv_val && strncmp(comp->a.bmpString->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.bmpString->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.bmpString);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentBMPString ( mem_op, cr, (comp->a.bmpString) );
		};
	}
	return NULL;
}  /* ExtractingComponentDirectoryString */

int
BDecComponentDirectoryString PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentDirectoryString **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentDirectoryString *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    switch (tagId0)
    {
       case MAKE_TAG_ID (UNIV, PRIM, TELETEXSTRING_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, TELETEXSTRING_TAG_CODE):
        (k->choiceId) = DIRECTORYSTRING_TELETEXSTRING;
		rc = 	BDecComponentTeletexString (mem_op, b, tagId0, elmtLen0, (&k->a.teletexString), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.teletexString)->identifier.bv_val = (k->a.teletexString)->id_buf;
		(k->a.teletexString)->identifier.bv_len = strlen("teletexString");
		strcpy( (k->a.teletexString)->identifier.bv_val, "teletexString");
    break;

       case MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE):
        (k->choiceId) = DIRECTORYSTRING_PRINTABLESTRING;
		rc = 	BDecComponentPrintableString (mem_op, b, tagId0, elmtLen0, (&k->a.printableString), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.printableString)->identifier.bv_val = (k->a.printableString)->id_buf;
		(k->a.printableString)->identifier.bv_len = strlen("printableString");
		strcpy( (k->a.printableString)->identifier.bv_val, "printableString");
    break;

       case MAKE_TAG_ID (UNIV, PRIM, UNIVERSALSTRING_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, UNIVERSALSTRING_TAG_CODE):
        (k->choiceId) = DIRECTORYSTRING_UNIVERSALSTRING;
		rc = 	BDecComponentUniversalString (mem_op, b, tagId0, elmtLen0, (&k->a.universalString), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.universalString)->identifier.bv_val = (k->a.universalString)->id_buf;
		(k->a.universalString)->identifier.bv_len = strlen("universalString");
		strcpy( (k->a.universalString)->identifier.bv_val, "universalString");
    break;

       case MAKE_TAG_ID (UNIV, PRIM, UTF8STRING_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, UTF8STRING_TAG_CODE):
        (k->choiceId) = DIRECTORYSTRING_UTF8STRING;
		rc = 	BDecComponentUTF8String (mem_op, b, tagId0, elmtLen0, (&k->a.utf8String), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.utf8String)->identifier.bv_val = (k->a.utf8String)->id_buf;
		(k->a.utf8String)->identifier.bv_len = strlen("utf8String");
		strcpy( (k->a.utf8String)->identifier.bv_val, "utf8String");
    break;

       case MAKE_TAG_ID (UNIV, PRIM, BMPSTRING_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, BMPSTRING_TAG_CODE):
        (k->choiceId) = DIRECTORYSTRING_BMPSTRING;
		rc = 	BDecComponentBMPString (mem_op, b, tagId0, elmtLen0, (&k->a.bmpString), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.bmpString)->identifier.bv_val = (k->a.bmpString)->id_buf;
		(k->a.bmpString)->identifier.bv_len = strlen("bmpString");
		strcpy( (k->a.bmpString)->identifier.bv_val, "bmpString");
    break;

    default:
        Asn1Error ("ERROR - unexpected tag in CHOICE\n");
        return -1;
        break;
    } /* end switch */
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentDirectoryString*) CompAlloc( mem_op, sizeof(ComponentDirectoryString) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentDirectoryString ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentDirectoryString ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentDirectoryString;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentDirectoryString;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecDirectoryStringContent */

int
GDecComponentDirectoryString PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentDirectoryString **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentDirectoryString *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen2 = LocateNextGSERToken(mem_op,b,&peek_head2,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head2 != ':'){
		Asn1Error("Missing : in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if( strncmp("teletexString",peek_head, strlen("teletexString")) == 0){
		(k->choiceId) = DIRECTORYSTRING_TELETEXSTRING;
		rc = 	GDecComponentTeletexString (mem_op, b, (&k->a.teletexString), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.teletexString)->identifier.bv_val = peek_head;
		(k->a.teletexString)->identifier.bv_len = strLen;
	}
	else if( strncmp("printableString",peek_head,strlen("printableString")) == 0){
		(k->choiceId) = DIRECTORYSTRING_PRINTABLESTRING;
		rc = 	GDecComponentPrintableString (mem_op, b, (&k->a.printableString), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.printableString)->identifier.bv_val = peek_head;
		(k->a.printableString)->identifier.bv_len = strLen;
	}
	else if( strncmp("universalString",peek_head,strlen("universalString")) == 0){
		(k->choiceId) = DIRECTORYSTRING_UNIVERSALSTRING;
		rc = 	GDecComponentUniversalString (mem_op, b, (&k->a.universalString), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.universalString)->identifier.bv_val = peek_head;
		(k->a.universalString)->identifier.bv_len = strLen;
	}
	else if( strncmp("utf8String",peek_head,strlen("utf8String")) == 0){
		(k->choiceId) = DIRECTORYSTRING_UTF8STRING;
		rc = 	GDecComponentUTF8String (mem_op, b, (&k->a.utf8String), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.utf8String)->identifier.bv_val = peek_head;
		(k->a.utf8String)->identifier.bv_len = strLen;
	}
	else if( strncmp("bmpString",peek_head,strlen("bmpString")) == 0){
		(k->choiceId) = DIRECTORYSTRING_BMPSTRING;
		rc = 	GDecComponentBMPString (mem_op, b, (&k->a.bmpString), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.bmpString)->identifier.bv_val = peek_head;
		(k->a.bmpString)->identifier.bv_len = strLen;
	}
	else {
		Asn1Error("Undefined Identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentDirectoryString*) CompAlloc( mem_op, sizeof(ComponentDirectoryString) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentDirectoryString ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentDirectoryString ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentDirectoryString;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentDirectoryString;
	return LDAP_SUCCESS;
}  /* GDecDirectoryStringContent */


int
MatchingComponentEDIPartyName ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	if(COMPONENTNOT_NULL( ((ComponentEDIPartyName*)csi_attr)->nameAssigner ) ) {
	rc =	MatchingComponentDirectoryString ( oid, (ComponentSyntaxInfo*)((ComponentEDIPartyName*)csi_attr)->nameAssigner, (ComponentSyntaxInfo*)((ComponentEDIPartyName*)csi_assert)->nameAssigner );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	rc =	MatchingComponentDirectoryString ( oid, (ComponentSyntaxInfo*)((ComponentEDIPartyName*)csi_attr)->partyName, (ComponentSyntaxInfo*)((ComponentEDIPartyName*)csi_assert)->partyName );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentEDIPartyName */

void*
ExtractingComponentEDIPartyName ( void* mem_op, ComponentReference* cr, ComponentEDIPartyName *comp )
{

	if ( ( comp->nameAssigner->identifier.bv_val && strncmp(comp->nameAssigner->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->nameAssigner->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->nameAssigner;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentDirectoryString ( mem_op, cr, comp->nameAssigner );
		}
	}
	if ( ( comp->partyName->identifier.bv_val && strncmp(comp->partyName->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->partyName->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->partyName;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentDirectoryString ( mem_op, cr, comp->partyName );
		}
	}
	return NULL;
}  /* ExtractingComponentEDIPartyName */

int
BDecComponentEDIPartyName PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentEDIPartyName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	AsnLen totalElmtsLen3 = 0;
	AsnLen elmtLen3;
	AsnTag tagId3;
	int old_mode = mode;
	int rc;
	ComponentEDIPartyName *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
		rc =     tagId2 = BDecTag (b, &totalElmtsLen1 );
    elmtLen2 = BDecLen (b, &totalElmtsLen1 );
	BDecComponentDirectoryString (mem_op, b, tagId2, elmtLen2, (&k->nameAssigner), &totalElmtsLen1, mode);
    if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc(b, &totalElmtsLen1 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->nameAssigner)->identifier.bv_val = (k->nameAssigner)->id_buf;
		(k->nameAssigner)->identifier.bv_len = strlen("nameAssigner");
		strcpy( (k->nameAssigner)->identifier.bv_val, "nameAssigner");
	if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }


    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
		rc =     tagId2 = BDecTag (b, &totalElmtsLen1 );
    elmtLen2 = BDecLen (b, &totalElmtsLen1 );
	BDecComponentDirectoryString (mem_op, b, tagId2, elmtLen2, (&k->partyName), &totalElmtsLen1, mode);
    if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc(b, &totalElmtsLen1 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->partyName)->identifier.bv_val = (k->partyName)->id_buf;
		(k->partyName)->identifier.bv_len = strlen("partyName");
		strcpy( (k->partyName)->identifier.bv_val, "partyName");
	if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentEDIPartyName*) CompAlloc( mem_op, sizeof(ComponentEDIPartyName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentEDIPartyName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentEDIPartyName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentEDIPartyName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentEDIPartyName;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecEDIPartyName*/

int
GDecComponentEDIPartyName PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentEDIPartyName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentEDIPartyName *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "nameAssigner", strlen("nameAssigner") ) == 0 ) {
		rc = 	GDecComponentDirectoryString (mem_op, b, (&k->nameAssigner), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->nameAssigner)->identifier.bv_val = peek_head;
	( k->nameAssigner)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "partyName", strlen("partyName") ) == 0 ) {
		rc = 	GDecComponentDirectoryString (mem_op, b, (&k->partyName), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->partyName)->identifier.bv_val = peek_head;
	( k->partyName)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentEDIPartyName*) CompAlloc( mem_op, sizeof(ComponentEDIPartyName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentEDIPartyName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentEDIPartyName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentEDIPartyName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentEDIPartyName;
	return LDAP_SUCCESS;
}  /* GDecEDIPartyName*/



int
MatchingComponentGeneralName ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	ComponentGeneralName *v1, *v2;


	v1 = (ComponentGeneralName*)csi_attr;
	v2 = (ComponentGeneralName*)csi_assert;
	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	if( (v1->choiceId != v2->choiceId ) )
		return LDAP_COMPARE_FALSE;
	switch( v1->choiceId )
	{
	   case GENERALNAME_OTHERNAME :
		rc = 	MatchingComponentOtherName ( oid, (ComponentSyntaxInfo*)(v1->a.otherName), (ComponentSyntaxInfo*)(v2->a.otherName) );
		break;
	   case GENERALNAME_RFC822NAME :
		rc = 	MatchingComponentIA5String ( oid, (ComponentSyntaxInfo*)(v1->a.rfc822Name), (ComponentSyntaxInfo*)(v2->a.rfc822Name) );
		break;
	   case GENERALNAME_DNSNAME :
		rc = 	MatchingComponentIA5String ( oid, (ComponentSyntaxInfo*)(v1->a.dNSName), (ComponentSyntaxInfo*)(v2->a.dNSName) );
		break;
	   case GENERALNAME_X400ADDRESS :
		rc = 	MatchingComponentORAddress ( oid, (ComponentSyntaxInfo*)(v1->a.x400Address), (ComponentSyntaxInfo*)(v2->a.x400Address) );
		break;
	   case GENERALNAME_DIRECTORYNAME :
		rc = 	MatchingComponentName ( oid, (ComponentSyntaxInfo*)(v1->a.directoryName), (ComponentSyntaxInfo*)(v2->a.directoryName) );
		break;
	   case GENERALNAME_EDIPARTYNAME :
		rc = 	MatchingComponentEDIPartyName ( oid, (ComponentSyntaxInfo*)(v1->a.ediPartyName), (ComponentSyntaxInfo*)(v2->a.ediPartyName) );
		break;
	   case GENERALNAME_UNIFORMRESOURCEIDENTIFIER :
		rc = 	MatchingComponentIA5String ( oid, (ComponentSyntaxInfo*)(v1->a.uniformResourceIdentifier), (ComponentSyntaxInfo*)(v2->a.uniformResourceIdentifier) );
		break;
	   case GENERALNAME_IPADDRESS :
		rc = 	MatchingComponentOcts ( oid, (ComponentSyntaxInfo*)(v1->a.iPAddress), (ComponentSyntaxInfo*)(v2->a.iPAddress) );
		break;
	   case GENERALNAME_REGISTEREDID :
		rc = 	MatchingComponentOid ( oid, (ComponentSyntaxInfo*)(v1->a.registeredID), (ComponentSyntaxInfo*)(v2->a.registeredID) );
		break;
	default : 
		 return LDAP_PROTOCOL_ERROR;
	}
	return rc;
}  /* BMatchingComponentGeneralNameContent */

void*
ExtractingComponentGeneralName ( void* mem_op, ComponentReference* cr, ComponentGeneralName *comp )
{


	if( (comp->choiceId) ==  GENERALNAME_OTHERNAME &&
		 (( comp->a.otherName->identifier.bv_val && strncmp(comp->a.otherName->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.otherName->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.otherName);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentOtherName ( mem_op, cr, (comp->a.otherName) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_RFC822NAME &&
		 (( comp->a.rfc822Name->identifier.bv_val && strncmp(comp->a.rfc822Name->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.rfc822Name->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.rfc822Name);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentIA5String ( mem_op, cr, (comp->a.rfc822Name) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_DNSNAME &&
		 (( comp->a.dNSName->identifier.bv_val && strncmp(comp->a.dNSName->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.dNSName->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.dNSName);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentIA5String ( mem_op, cr, (comp->a.dNSName) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_X400ADDRESS &&
		 (( comp->a.x400Address->identifier.bv_val && strncmp(comp->a.x400Address->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.x400Address->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.x400Address);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentORAddress ( mem_op, cr, (comp->a.x400Address) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_DIRECTORYNAME &&
		 (( comp->a.directoryName->identifier.bv_val && strncmp(comp->a.directoryName->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.directoryName->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.directoryName);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentName ( mem_op, cr, (comp->a.directoryName) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_EDIPARTYNAME &&
		 (( comp->a.ediPartyName->identifier.bv_val && strncmp(comp->a.ediPartyName->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.ediPartyName->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.ediPartyName);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentEDIPartyName ( mem_op, cr, (comp->a.ediPartyName) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_UNIFORMRESOURCEIDENTIFIER &&
		 (( comp->a.uniformResourceIdentifier->identifier.bv_val && strncmp(comp->a.uniformResourceIdentifier->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.uniformResourceIdentifier->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.uniformResourceIdentifier);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentIA5String ( mem_op, cr, (comp->a.uniformResourceIdentifier) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_IPADDRESS &&
		 (( comp->a.iPAddress->identifier.bv_val && strncmp(comp->a.iPAddress->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.iPAddress->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.iPAddress);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentOcts ( mem_op, cr, (comp->a.iPAddress) );
		};
	}
	if( (comp->choiceId) ==  GENERALNAME_REGISTEREDID &&
		 (( comp->a.registeredID->identifier.bv_val && strncmp(comp->a.registeredID->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.registeredID->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.registeredID);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentOid ( mem_op, cr, (comp->a.registeredID) );
		};
	}
	return NULL;
}  /* ExtractingComponentGeneralName */

int
BDecComponentGeneralName PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentGeneralName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	AsnLen totalElmtsLen3 = 0;
	AsnLen elmtLen3;
	AsnTag tagId3;
	int old_mode = mode;
	int rc;
	ComponentGeneralName *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    switch (tagId0)
    {
       case MAKE_TAG_ID (CNTX, CONS, 0):
if (BDecTag (b, &totalElmtsLen1 ) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_OTHERNAME;
		rc = 	BDecComponentOtherName (mem_op, b, tagId1, elmtLen1, (&k->a.otherName), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.otherName)->identifier.bv_val = (k->a.otherName)->id_buf;
		(k->a.otherName)->identifier.bv_len = strlen("otherName");
		strcpy( (k->a.otherName)->identifier.bv_val, "otherName");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 1):
    tagId1 = BDecTag (b, &totalElmtsLen1 );
if ((tagId1 != MAKE_TAG_ID (UNIV, PRIM, IA5STRING_TAG_CODE)) &&
   (tagId1 != MAKE_TAG_ID (UNIV, CONS, IA5STRING_TAG_CODE)))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_RFC822NAME;
		rc = 	BDecComponentIA5String (mem_op, b, tagId1, elmtLen1, (&k->a.rfc822Name), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.rfc822Name)->identifier.bv_val = (k->a.rfc822Name)->id_buf;
		(k->a.rfc822Name)->identifier.bv_len = strlen("rfc822Name");
		strcpy( (k->a.rfc822Name)->identifier.bv_val, "rfc822Name");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 2):
    tagId1 = BDecTag (b, &totalElmtsLen1 );
if ((tagId1 != MAKE_TAG_ID (UNIV, PRIM, IA5STRING_TAG_CODE)) &&
   (tagId1 != MAKE_TAG_ID (UNIV, CONS, IA5STRING_TAG_CODE)))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_DNSNAME;
		rc = 	BDecComponentIA5String (mem_op, b, tagId1, elmtLen1, (&k->a.dNSName), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.dNSName)->identifier.bv_val = (k->a.dNSName)->id_buf;
		(k->a.dNSName)->identifier.bv_len = strlen("dNSName");
		strcpy( (k->a.dNSName)->identifier.bv_val, "dNSName");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 3):
if (BDecTag (b, &totalElmtsLen1 ) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_X400ADDRESS;
		rc = 	BDecComponentORAddress (mem_op, b, tagId1, elmtLen1, (&k->a.x400Address), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.x400Address)->identifier.bv_val = (k->a.x400Address)->id_buf;
		(k->a.x400Address)->identifier.bv_len = strlen("x400Address");
		strcpy( (k->a.x400Address)->identifier.bv_val, "x400Address");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 4):
        (k->choiceId) = GENERALNAME_DIRECTORYNAME;
		tagId1 = BDecTag (b, &totalElmtsLen1 );
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentName (mem_op, b, tagId1, elmtLen1, (&k->a.directoryName), &totalElmtsLen1, mode);
    if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc(b, &totalElmtsLen1 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.directoryName)->identifier.bv_val = (k->a.directoryName)->id_buf;
		(k->a.directoryName)->identifier.bv_len = strlen("directoryName");
		strcpy( (k->a.directoryName)->identifier.bv_val, "directoryName");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 5):
if (BDecTag (b, &totalElmtsLen1 ) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_EDIPARTYNAME;
		rc = 	BDecComponentEDIPartyName (mem_op, b, tagId1, elmtLen1, (&k->a.ediPartyName), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.ediPartyName)->identifier.bv_val = (k->a.ediPartyName)->id_buf;
		(k->a.ediPartyName)->identifier.bv_len = strlen("ediPartyName");
		strcpy( (k->a.ediPartyName)->identifier.bv_val, "ediPartyName");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 6):
    tagId1 = BDecTag (b, &totalElmtsLen1 );
if ((tagId1 != MAKE_TAG_ID (UNIV, PRIM, IA5STRING_TAG_CODE)) &&
   (tagId1 != MAKE_TAG_ID (UNIV, CONS, IA5STRING_TAG_CODE)))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_UNIFORMRESOURCEIDENTIFIER;
		rc = 	BDecComponentIA5String (mem_op, b, tagId1, elmtLen1, (&k->a.uniformResourceIdentifier), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.uniformResourceIdentifier)->identifier.bv_val = (k->a.uniformResourceIdentifier)->id_buf;
		(k->a.uniformResourceIdentifier)->identifier.bv_len = strlen("uniformResourceIdentifier");
		strcpy( (k->a.uniformResourceIdentifier)->identifier.bv_val, "uniformResourceIdentifier");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 7):
    tagId1 = BDecTag (b, &totalElmtsLen1 );
if ((tagId1 != MAKE_TAG_ID (UNIV, PRIM, OCTETSTRING_TAG_CODE)) &&
   (tagId1 != MAKE_TAG_ID (UNIV, CONS, OCTETSTRING_TAG_CODE)))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_IPADDRESS;
		rc = 	BDecComponentOcts (mem_op, b, tagId1, elmtLen1, (&k->a.iPAddress), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.iPAddress)->identifier.bv_val = (k->a.iPAddress)->id_buf;
		(k->a.iPAddress)->identifier.bv_len = strlen("iPAddress");
		strcpy( (k->a.iPAddress)->identifier.bv_val, "iPAddress");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

       case MAKE_TAG_ID (CNTX, CONS, 8):
if (BDecTag (b, &totalElmtsLen1 ) != MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        (k->choiceId) = GENERALNAME_REGISTEREDID;
		rc = 	BDecComponentOid (mem_op, b, tagId1, elmtLen1, (&k->a.registeredID), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.registeredID)->identifier.bv_val = (k->a.registeredID)->id_buf;
		(k->a.registeredID)->identifier.bv_len = strlen("registeredID");
		strcpy( (k->a.registeredID)->identifier.bv_val, "registeredID");
	if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    break;

    default:
        Asn1Error ("ERROR - unexpected tag in CHOICE\n");
        return -1;
        break;
    } /* end switch */
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentGeneralName*) CompAlloc( mem_op, sizeof(ComponentGeneralName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentGeneralName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentGeneralName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentGeneralName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentGeneralName;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecGeneralNameContent */

int
GDecComponentGeneralName PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentGeneralName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentGeneralName *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen2 = LocateNextGSERToken(mem_op,b,&peek_head2,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head2 != ':'){
		Asn1Error("Missing : in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if( strncmp("otherName",peek_head, strlen("otherName")) == 0){
		(k->choiceId) = GENERALNAME_OTHERNAME;
		rc = 	GDecComponentOtherName (mem_op, b, (&k->a.otherName), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.otherName)->identifier.bv_val = peek_head;
		(k->a.otherName)->identifier.bv_len = strLen;
	}
	else if( strncmp("rfc822Name",peek_head,strlen("rfc822Name")) == 0){
		(k->choiceId) = GENERALNAME_RFC822NAME;
		rc = 	GDecComponentIA5String (mem_op, b, (&k->a.rfc822Name), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.rfc822Name)->identifier.bv_val = peek_head;
		(k->a.rfc822Name)->identifier.bv_len = strLen;
	}
	else if( strncmp("dNSName",peek_head,strlen("dNSName")) == 0){
		(k->choiceId) = GENERALNAME_DNSNAME;
		rc = 	GDecComponentIA5String (mem_op, b, (&k->a.dNSName), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.dNSName)->identifier.bv_val = peek_head;
		(k->a.dNSName)->identifier.bv_len = strLen;
	}
	else if( strncmp("x400Address",peek_head,strlen("x400Address")) == 0){
		(k->choiceId) = GENERALNAME_X400ADDRESS;
		rc = 	GDecComponentORAddress (mem_op, b, (&k->a.x400Address), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.x400Address)->identifier.bv_val = peek_head;
		(k->a.x400Address)->identifier.bv_len = strLen;
	}
	else if( strncmp("directoryName",peek_head,strlen("directoryName")) == 0){
		(k->choiceId) = GENERALNAME_DIRECTORYNAME;
		rc = 	GDecComponentName (mem_op, b, (&k->a.directoryName), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.directoryName)->identifier.bv_val = peek_head;
		(k->a.directoryName)->identifier.bv_len = strLen;
	}
	else if( strncmp("ediPartyName",peek_head,strlen("ediPartyName")) == 0){
		(k->choiceId) = GENERALNAME_EDIPARTYNAME;
		rc = 	GDecComponentEDIPartyName (mem_op, b, (&k->a.ediPartyName), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.ediPartyName)->identifier.bv_val = peek_head;
		(k->a.ediPartyName)->identifier.bv_len = strLen;
	}
	else if( strncmp("uniformResourceIdentifier",peek_head,strlen("uniformResourceIdentifier")) == 0){
		(k->choiceId) = GENERALNAME_UNIFORMRESOURCEIDENTIFIER;
		rc = 	GDecComponentIA5String (mem_op, b, (&k->a.uniformResourceIdentifier), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.uniformResourceIdentifier)->identifier.bv_val = peek_head;
		(k->a.uniformResourceIdentifier)->identifier.bv_len = strLen;
	}
	else if( strncmp("iPAddress",peek_head,strlen("iPAddress")) == 0){
		(k->choiceId) = GENERALNAME_IPADDRESS;
		rc = 	GDecComponentOcts (mem_op, b, (&k->a.iPAddress), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.iPAddress)->identifier.bv_val = peek_head;
		(k->a.iPAddress)->identifier.bv_len = strLen;
	}
	else if( strncmp("registeredID",peek_head,strlen("registeredID")) == 0){
		(k->choiceId) = GENERALNAME_REGISTEREDID;
		rc = 	GDecComponentOid (mem_op, b, (&k->a.registeredID), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.registeredID)->identifier.bv_val = peek_head;
		(k->a.registeredID)->identifier.bv_len = strLen;
	}
	else {
		Asn1Error("Undefined Identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentGeneralName*) CompAlloc( mem_op, sizeof(ComponentGeneralName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentGeneralName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentGeneralName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentGeneralName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentGeneralName;
	return LDAP_SUCCESS;
}  /* GDecGeneralNameContent */


int
MatchingComponentGeneralNames ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	void* component1, *component2;
	AsnList *v1, *v2, t_list;


	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	v1 = &((ComponentGeneralNames*)csi_attr)->comp_list;
	v2 = &((ComponentGeneralNames*)csi_assert)->comp_list;
	FOR_EACH_LIST_PAIR_ELMT(component1, component2, v1, v2)
	{
		if( MatchingComponentGeneralName(oid, (ComponentSyntaxInfo*)component1, (ComponentSyntaxInfo*)component2) == LDAP_COMPARE_FALSE) {
			return LDAP_COMPARE_FALSE;
		}
	} /* end of for */

	AsnListFirst( v1 );
	AsnListFirst( v2 );
	if( (!component1 && component2) || (component1 && !component2))
		return LDAP_COMPARE_FALSE;
	else
		return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentGeneralNamesContent */

void*
ExtractingComponentGeneralNames ( void* mem_op, ComponentReference* cr, ComponentGeneralNames *comp )
{
	int count = 0;
	int total;
	AsnList *v = &comp->comp_list;
	ComponentInt *k;
	ComponentGeneralName *component;


	switch ( cr->cr_curr->ci_type ) {
	case LDAP_COMPREF_FROM_BEGINNING :
		count = cr->cr_curr->ci_val.ci_from_beginning;
		FOR_EACH_LIST_ELMT( component , v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL )
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentGeneralName ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_FROM_END :
		total = AsnListCount ( v );
		count = cr->cr_curr->ci_val.ci_from_end;
		count = total + count +1;
		FOR_EACH_LIST_ELMT ( component, v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL ) 
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentGeneralName ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_ALL :
		return comp;
	case LDAP_COMPREF_COUNT :
		k = (ComponentInt*)CompAlloc( mem_op, sizeof(ComponentInt));
		k->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
		k->comp_desc->cd_tag = (-1);
		k->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentInt;
		k->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentInt;
		k->comp_desc->cd_extract_i = (extract_component_from_id_func*)NULL;
		k->comp_desc->cd_type = ASN_BASIC;
		k->comp_desc->cd_type_id = BASICTYPE_INTEGER;
		k->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentInt;
		k->value = AsnListCount(v);
		return k;
	default :
		return NULL;
	}
}  /* ExtractingComponentGeneralNames */

int
BDecComponentGeneralNames PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentGeneralNames **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentGeneralNames *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit(&k->comp_list,sizeof(ComponentGeneralName));
    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        ComponentGeneralName **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
        elmtLen1 = BDecLen (b, &totalElmtsLen1);
    tmpVar = (ComponentGeneralName**) CompAsnListAppend (mem_op,&k->comp_list);
		rc = 	BDecComponentGeneralName (mem_op, b, tagId1, elmtLen1, tmpVar, &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
    } /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentGeneralNames*) CompAlloc( mem_op, sizeof(ComponentGeneralNames) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentGeneralNames ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentGeneralNames ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentGeneralNames;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentGeneralNames;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecGeneralNamesContent */

int
GDecComponentGeneralNames PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentGeneralNames **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentGeneralNames *k,*t, c_temp;


	int ElmtsLen1;
	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit( &k->comp_list, sizeof( ComponentGeneralName ) );
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_PEEK)) ){
		Asn1Error("Error during Reading { in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	for (ElmtsLen1 = 0; ElmtsLen1 >= INDEFINITE_LEN; ElmtsLen1++)
	{
		ComponentGeneralName **tmpVar;
		if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_NO_COPY)) ){
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		if(*peek_head == '}') break;
		if( !(*peek_head == '{' || *peek_head ==',') ) {
			return LDAP_PROTOCOL_ERROR;
		}
		tmpVar = (ComponentGeneralName**) CompAsnListAppend (mem_op, &k->comp_list);
		if ( tmpVar == NULL ) {
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		rc = 	GDecComponentGeneralName (mem_op, b, tmpVar, bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	} /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentGeneralNames*) CompAlloc( mem_op, sizeof(ComponentGeneralNames) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentGeneralNames ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentGeneralNames ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentGeneralNames;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentGeneralNames;
	return LDAP_SUCCESS;
}  /* GDecGeneralNamesContent */


int
MatchingComponentAuthorityKeyIdentifier ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentKeyIdentifier ( oid, (ComponentSyntaxInfo*)&((ComponentAuthorityKeyIdentifier*)csi_attr)->keyIdentifier, (ComponentSyntaxInfo*)&((ComponentAuthorityKeyIdentifier*)csi_assert)->keyIdentifier );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	if(COMPONENTNOT_NULL( ((ComponentAuthorityKeyIdentifier*)csi_attr)->authorityCertIssuer ) ) {
	rc =	MatchingComponentGeneralNames ( oid, (ComponentSyntaxInfo*)((ComponentAuthorityKeyIdentifier*)csi_attr)->authorityCertIssuer, (ComponentSyntaxInfo*)((ComponentAuthorityKeyIdentifier*)csi_assert)->authorityCertIssuer );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	if(COMPONENTNOT_NULL( ((ComponentAuthorityKeyIdentifier*)csi_attr)->authorityCertSerialNumber ) ) {
	rc =	MatchingComponentCertificateSerialNumber ( oid, (ComponentSyntaxInfo*)((ComponentAuthorityKeyIdentifier*)csi_attr)->authorityCertSerialNumber, (ComponentSyntaxInfo*)((ComponentAuthorityKeyIdentifier*)csi_assert)->authorityCertSerialNumber );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentAuthorityKeyIdentifier */

void*
ExtractingComponentAuthorityKeyIdentifier ( void* mem_op, ComponentReference* cr, ComponentAuthorityKeyIdentifier *comp )
{

	if ( ( comp->keyIdentifier.identifier.bv_val && strncmp(comp->keyIdentifier.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->keyIdentifier.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->keyIdentifier;
		else
		return NULL;
	}
	if ( ( comp->authorityCertIssuer->identifier.bv_val && strncmp(comp->authorityCertIssuer->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->authorityCertIssuer->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->authorityCertIssuer;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentGeneralNames ( mem_op, cr, comp->authorityCertIssuer );
		}
	}
	if ( ( comp->authorityCertSerialNumber->identifier.bv_val && strncmp(comp->authorityCertSerialNumber->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->authorityCertSerialNumber->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->authorityCertSerialNumber;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentCertificateSerialNumber ( mem_op, cr, comp->authorityCertSerialNumber );
		}
	}
	return NULL;
}  /* ExtractingComponentAuthorityKeyIdentifier */

int
BDecComponentAuthorityKeyIdentifier PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentAuthorityKeyIdentifier **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	int old_mode = mode;
	int rc;
	ComponentAuthorityKeyIdentifier *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }

    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 0)) ||
(tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
                rc =    BDecComponentKeyIdentifier (mem_op, b, tagId1, elmtLen1, (&k->keyIdentifier), &totalElmtsLen1, mode);
                if ( rc != LDAP_SUCCESS ) return rc;
                (&k->keyIdentifier)->identifier.bv_val = (&k->keyIdentifier)->id_buf;
                (&k->keyIdentifier)->identifier.bv_len = strlen("keyIdentifier");
                strcpy( (&k->keyIdentifier)->identifier.bv_val, "keyIdentifier");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );
                                                                                
         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }

    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, CONS, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
                rc =    BDecComponentGeneralNames (mem_op, b, tagId1, elmtLen1,
(&k->authorityCertIssuer), &totalElmtsLen1, mode);
                if ( rc != LDAP_SUCCESS ) return rc;
                (k->authorityCertIssuer)->identifier.bv_val = (k->authorityCertIssuer)->id_buf;
                (k->authorityCertIssuer)->identifier.bv_len = strlen("authorityCertIssuer");
                strcpy( (k->authorityCertIssuer)->identifier.bv_val, "authorityCertIssuer");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );
                                                                                
         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }

    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 2))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
                rc =    BDecComponentCertificateSerialNumber (mem_op, b, tagId1, elmtLen1, (&k->authorityCertSerialNumber), &totalElmtsLen1, DEC_ALLOC_MODE_0 );                if ( rc != LDAP_SUCCESS ) return rc;
                (k->authorityCertSerialNumber)->identifier.bv_val = (k->authorityCertSerialNumber)->id_buf;
                (k->authorityCertSerialNumber)->identifier.bv_len = strlen("authorityCertSerialNumber");
                strcpy( (k->authorityCertSerialNumber)->identifier.bv_val, "authorityCertSerialNumber");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;
                                                                                
    }

    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentAuthorityKeyIdentifier*) CompAlloc( mem_op, sizeof(ComponentAuthorityKeyIdentifier) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentAuthorityKeyIdentifier ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentAuthorityKeyIdentifier ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentAuthorityKeyIdentifier;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentAuthorityKeyIdentifier;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecAuthorityKeyIdentifier*/

int
GDecComponentAuthorityKeyIdentifier PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentAuthorityKeyIdentifier **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentAuthorityKeyIdentifier *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "keyIdentifier", strlen("keyIdentifier") ) == 0 ) {
		rc = 	GDecComponentKeyIdentifier (mem_op, b, (&k->keyIdentifier), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->keyIdentifier)->identifier.bv_val = peek_head;
	(&k->keyIdentifier)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "authorityCertIssuer", strlen("authorityCertIssuer") ) == 0 ) {
		rc = 	GDecComponentGeneralNames (mem_op, b, (&k->authorityCertIssuer), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->authorityCertIssuer)->identifier.bv_val = peek_head;
	( k->authorityCertIssuer)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "authorityCertSerialNumber", strlen("authorityCertSerialNumber") ) == 0 ) {
		rc = 	GDecComponentCertificateSerialNumber (mem_op, b, (&k->authorityCertSerialNumber), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->authorityCertSerialNumber)->identifier.bv_val = peek_head;
	( k->authorityCertSerialNumber)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentAuthorityKeyIdentifier*) CompAlloc( mem_op, sizeof(ComponentAuthorityKeyIdentifier) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentAuthorityKeyIdentifier ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentAuthorityKeyIdentifier ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentAuthorityKeyIdentifier;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentAuthorityKeyIdentifier;
	return LDAP_SUCCESS;
}  /* GDecAuthorityKeyIdentifier*/


