/*	$NetBSD: floppy_2d.c,v 1.5 2009/02/04 15:22:13 tsutsui Exp $	*/

/*-
 * Copyright (c) 2004 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by UCHIYAMA Yasushi.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include "common.h"

bool
blk_to_2d_position(uint32_t logical_block_number, uint32_t *position,
    int *count)
{
	int i, sector, side, cylinder;

	/*
	 * 2D: MFM format (cylinder 0 side 0 is FM format)
	 *     77 cylinders/disk
	 *	2 sides/disk
	 *     26 sectors/track
	 *    256 bytes/sector (cylinder 0 side 0 is 128 bytes/sector)
	 *
	 *    0-1988 : MFM
	 * 1989-1995 : FM
	 */
	if (logical_block_number > 1988)
		return false;	/* don't support FM track */

	i = logical_block_number * 2 + 26;
	cylinder = i / (26 * 2);
	side = i - (cylinder * 26 * 2) > 25;
	sector = i - (side + cylinder * 2) * 26;
	if (position)
		*position = (cylinder << 16) | (side << 8) | (sector + 1);
	if (count)
		*count = (26 - sector) / 2;

	return true;
}

