/* File:	Magnify.h - Application class for 'Magnify'
 *
 * By:		Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	6 March 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.  This program
 *		may be distributed without restriction for non-commercial use.
 */
 
#import <appkit/appkit.h>

#import "MagnifyView.h"

#define VERSION __DATE__
#define APPLICATION "Magnify"

#define SCALEDEFAULTSTRING "Scale"
#define DEFAULTSCALESTRING "4.0"
#define DEFAULTSCALE ((float) 4.0)

#define FROZENMENUCELLTAG (1)
#define FROZENMENUTITLE "Freeze"
#define UNFROZENMENUTITLE "Unfreeze"

#define WINDOWTITLEFORMAT "%gx Magnification"
#define WINDOWTITLEPROTOTYPE "100.00x Magnification"

@interface Magnify : Application
{ 
	MagnifyView *view;
	float scale;
	id version;
}

+ new;

- appDidInit:sender;
- hide:sender;
- unhide:sender;

- changeScale:sender;
- (float) getScale;

- (MagnifyView *) getView;
- setView:(MagnifyView *) anObject;
- setVersion:anObject;

- setWindowTitle;

@end
