#import <string.h>
#import <time.h>
#import "DirEntry.h"

#ifdef FTPPARSE_MAIN
#import <stdio.h>
#import <libc.h>
#import <ctype.h>
#import <sys/file.h>
#include <regex.h>
#endif

enum {Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec};
static const char *monthNames[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
				"Jul","Aug", "Sep", "Oct", "Nov", "Dec", ""};
static const char *monthFirstLetters = "JFMASOND";
static int thisYear, thisMonth, thisDay;
static struct regex *months;

/* Get the next line from the 'ftp dir' output */
char *NextEntry(char *buffer)
{
static char *searchBuffer;
char *tmp,tmp_c;
int count;
	/* If buffer is NULL, use the last searchBuffer */
	if(buffer != NULL)
		searchBuffer = buffer;
	/* Find the next "\n[d-][rwxs-]x9" sequence in buffer */
	tmp = index(searchBuffer,'\n');
	if(tmp == NULL)
		return (char *) -1;	// Error condition

	/* Check next 10 characters for the unix mode info */
	searchBuffer = ++tmp;
	if(strlen(tmp) < 11)
		return NULL;	// Not a valid dir format

	tmp_c = tmp[10];		// Save the 11th char
	tmp[10] = '\0';
	count = strspn(tmp,"drwxs-");
	tmp[10] = tmp_c;
	/* A unix mode was found if every char was in the "drwxs-" span */
	if(count == 10)
		return tmp;
	return NULL;
}

/* Search the line from the ftp dir output and return the file information.
	Returns 0 on sucess with buffer set to the file name, -1 on failure. */
int ParseAttributes(char **buffer,int *size,int *month,int *day,int *year,int *hr,int *min)
{
char *tmpPtr,*datePtr,*dayPtr,*yr_timePtr;
int success;

	// Look for the month regular expression
	if( re_match(*buffer,months) == 1 )
	{
		datePtr = tmpPtr = (months->start + 2);
	}
	else
	{	// Find the start of the date string by locating its 3 letter month code
		datePtr = tmpPtr = strpbrk(*buffer,monthFirstLetters);
	}

	if(tmpPtr == NULL)
		return -1;
	/* Make sure this is a month name */
	switch(tmpPtr[0])
	{
		case 'J' :
			success = !strncmp(tmpPtr,monthNames[Jan],3);
			if(success)
			{
				*month = 1;
				break;
			}
			success = !strncmp(tmpPtr,monthNames[Jun],3);
			if(success)
			{
				*month = 6;
				break;
			}
			success = !strncmp(tmpPtr,monthNames[Jul],3);
			if(success)
			{
				*month = 7;
				break;
			}
			return -1;
			break;
		case 'F' :
			if(strncmp(tmpPtr,monthNames[Feb],3) != 0)
				return -1;
			*month = 2;
			break;
		case 'M' :
			success = !strncmp(tmpPtr,monthNames[Mar],3);
			if(success)
			{
				*month = 3;
				break;
			}
			success = !strncmp(tmpPtr,monthNames[May],3);
			if(success)
			{
				*month = 5;
				break;
			}
			return -1;
			break;
		case 'A' :
			success = !strncmp(tmpPtr,monthNames[Apr],3);
			if(success)
			{
				*month = 4;
				break;
			}
			success = !strncmp(tmpPtr,monthNames[Aug],3);
			if(success)
			{
				*month = 8;
				break;
			}
			return -1;
			break;
		case 'S' :
			if(strncmp(tmpPtr,monthNames[Sep],3) != 0)
				return -1;
			*month = 9;
			break;
		case 'O' :
			if(strncmp(tmpPtr,monthNames[Oct],3) != 0)
				return -1;
			*month = 10;
			break;
		case 'N' :
			if(strncmp(tmpPtr,monthNames[Nov],3) != 0)
				return -1;
			*month = 11;
			break;
		case 'D' :
			if(strncmp(tmpPtr,monthNames[Dec],3) != 0)
				return -1;
			*month = 12;
			break;
		default :
			return -1;	// Never should happen
	}
	/* Now backup to the start of the size field */
	while( isdigit(*tmpPtr) == 0)
		tmpPtr --;
	/* And to the start of the date */
	while( isdigit(*tmpPtr) != 0)
		tmpPtr --;
	sscanf(++tmpPtr,"%d",size);
	/* Get the day */
	datePtr += 4;
	while( isdigit(*datePtr) == 0)
		datePtr ++;
	dayPtr = datePtr;	// A pointer to the date
	while( isdigit(*datePtr) != 0)
		datePtr ++;
	*datePtr = '\0';
	*day = atoi(dayPtr);
	/* Get the year or time */
	datePtr ++;
	while( isdigit(*datePtr) == 0)
		datePtr ++;
	yr_timePtr = datePtr;	// A pointer to the year or time
	while( isdigit(*datePtr) != 0)
		datePtr ++;
	if( *datePtr == ':')
	{	// This is the time, file < 12 months old
		sscanf(yr_timePtr,"%d:%d",hr,min);
		// Figure the year of the file
		if( *month > thisMonth )
			*year = thisYear - 1;
		else if( *month == thisMonth && *day > thisDay)
			*year = thisYear - 1;
		else
			*year = thisYear;
		datePtr += 3;
	}
	else
	{
		*datePtr = '\0';
		*year = atoi(yr_timePtr);
		*hr = *min = 0;
		datePtr ++;
	}
	/* Lastly set the buffer to the file name */
	while( isspace(*datePtr) != 0)
		datePtr ++;
	*buffer = datePtr;
	return 0;
}


DirEntryPtr ParseBuffer(char *buffer)
{
DirEntryPtr tmp,list;
char lineBuffer[128],*tmpPtr,*linkName;
int size,month,day,year,hr,min;
struct tm *timeStruct;
time_t now;

	time(&now);
	timeStruct = localtime(&now);
	thisDay = timeStruct->tm_mday;
	thisMonth = timeStruct->tm_mon + 1;
	thisYear = timeStruct->tm_year + 1900;
	months = re_compile("[0-9] [JFMASOND][aepuco][nbrylgptvc] [1-3]",0);

	tmpPtr = buffer;
	list = NULL;
	while( (tmpPtr = NextEntry(tmpPtr)) != (char *) -1 )
	{
		if(tmpPtr != NULL)
		{
			sscanf(tmpPtr,"%[^\n]",lineBuffer);
			tmpPtr = lineBuffer + 10;
			if(ParseAttributes(&tmpPtr,&size,&month,&day,&year,&hr,&min) == 0)
			{
				/* Don't display the '.' or '..' files */
				if(strcmp(tmpPtr,".") == 0 || strcmp(tmpPtr,"..") == 0)
				{
					tmpPtr = NULL;
					continue;
				}

				if(list == NULL)
					tmp = list = (DirEntryPtr) malloc(sizeof(DirEntry));
				else
				{
					tmp->next = (DirEntryPtr) malloc(sizeof(DirEntry));
					tmp = tmp->next;
				}
				strncpy(tmp->mode,lineBuffer,10);
				sprintf(tmp->date,"%.4d%.2d%.2d%.2d%.2d",
					year,month,day,hr,min);
				tmp->bytes = size;
				/* Handle links - Ignore them for now
				if(lineBuffer[0] == 'l')
				{
					linkName = index(tmpPtr,'>');
					linkName -= 2;	// move back before "->"
					while( isspace(*linkName) != 0)
						linkName --;
					*(++linkName) = '\0';
				} */
				tmp->name = (char *) malloc(strlen(tmpPtr)+1);
				strcpy(tmp->name,tmpPtr);
				tmp->next = NULL;
			}
			tmpPtr = NULL;
		}
	}
	return list;
}

void PrintDirList(DirEntryPtr list)
{
	while(list != NULL)
	{
		fprintf(stderr,"%s %d %s %s\n",list->mode,list->bytes,list->date,list->name);
		list = list->next;
	}
}


#ifdef FTPPARSE_MAIN
char buffer[4096];
main(int argc,char **argv)
{
int fd,n;
DirEntryPtr list;

	fd = open((argc == 1 ? "./ftp_dir.out" : argv[1]),O_RDONLY);
	n = read(fd,buffer,4095);
	printf("Read %d bytes\n",n);
	
	/* Parse the file entries */
	list = ParseBuffer(buffer);
	PrintDirList(list);
}
#endif //FTPPARSE_MAIN

/* RCS Information:
	$Author: me $;
	$Date: 92/05/03 17:25:15 $;
	$Source: /RS6000/usr/local/NFS_NeXT/Dev/Net/Archie_Prospero/Archie/RCS/ftpParse.c,v $;
	$Revision: 1.4 $;
*/
