/* A subclass of the Date class which holds the Prospero VLINK info returned by the
	archie_query() procedure */

#import <Date.h>	// My Date class
#import <pfs.h>		// Prospero defines, structs
#import <objc/hashtable.h>	// NXAtom type
#import "DirEntry.h"

/* struct pattrib name attributes. I could not find these in the prospero includes
	so they are subject to becoming invalid. */
#define SIZE		"SIZE"
#define MODES	"UNIX-MODES"
#define DATE	"LAST-MODIFIED"

@interface ProsperoVLINK : Date
{
	int fileSize;			// File size in bytes
	char unixMode[10];	// UNIX files modes
	NXAtom hostname;	// A unique system host
	char *filePath;		// System pathname
	int componentIndex;	// Offset into filePath of the file component
	int fileDepth;		// The level of the file in the directory tree
	char *subPath;		// The buffer for the subpath name returned by the nameAtLevel: method
	id listing;			// A List of ProsperoVLINKs which hold the result of
						// a ftp dir command.  Only used if a user requests a directory listing
						// and then only to a depth of 1 below the original query directory.
	// Modification date is represented by the Date superclass members
}

/* Initialize an instance from a VLINK structure */
- initVLINK:(VLINK) v;
- initVLINK : (DirEntryPtr) dirList host: (const char *) host
	parent: (const char *) parentPath;
- setListing:(DirEntryPtr) list;

/* Instance variable access methods */
- (int) fileSize;
- (int) mode;				// Octal mode representation
- (const char *) unixMode;	// ls -l mode representation
- (BOOL) isDirectory;
- (int) fileDepth;		// Level of file.  Root files have fileDepth == 1
- (const char *) filePath;
- (const char *) fileName;
- (const char *) hostname;
- listing;

/* Returns the filename at the requested level.  Returns NULL if
	level is greater than fileDepth */
- (const char *) nameAtLevel: (int) level;

@end
/* RCS Information:
	$Author: me $;
	$Date: 92/05/03 17:25:37 $;
	$Source: /RS6000/usr/local/NFS_NeXT/Dev/Net/Archie_Prospero/Archie/RCS/ProsperoVLINK.h,v $;
	$Revision: 1.4 $;
*/
