/* An Objective-C class that provides the functionality of the archie.c program
	distributed in the beta.4.2 propspero release.
	See the the ArchieServer.m file for the original UW copyright
	info include and archie authors.
	Scott Stark Wed Jan 15 1992 <stark@superc.che.udel.edu>
*/

#import <objc/Object.h>
#import <appkit/Pasteboard.h>
#import <pfs.h>		// Defines the VLINK typedef
#import <cthreads.h>
#import <dpsclient/dpsclient.h>

@interface ArchieServer : Object
{
	/* Command line flags of the archie program set through the
		preferences panel */
	char queryType;	// The type of pattern matching request.  Corresponds to
					//	the archie -cers flags
	int maxReplies;	// The maximum number of query matches to be returned. 
					// Corresponds to the archie -m flag
	int offset;		// Return only 1 out of (1+offset) matches. Not used now.
	int sortType;	// Sort by hostname/filename, by modification date or not at all
	BOOL exactFlag;	// Exact match flag
	int (*cmpProc)(VLINK p,VLINK q);	// The sort comparison procedure
	int niceLevel;		// The query niceness level
	int hostTag;
	const char *hostname;	// The Archie hostname
	int	debugLevel;		// The Prospero debugging level

	/* Preference Panel outlets */
	id prefPanelID;		// Peferences Panel
	id hostMatrixID;		// Hostname object
	id customHostID;	// TextField for the custom hostname
	id sortMatrixID;		// Sort method object
	id patternMatrixID;	// Pattern matching object
	id exactBtnID;		// Exact match flag object
	id niceMatrixID;		// Niceness object
	id hitsFormID;		// Max hits object
	id debugMatrixID;	// Debug level object
	id allowHideBtnID;	// Run modal status flag

	/* Outlets to the main nib file */
	id mainWindowID;	// The main window
	id fileBrowserID;	// The Browser which display the server responses
	id queryFieldID;		// The query TextField
	id fileInfoID;			// File info Form
	id readMatrixID;		// Permission matrices
	id writeMatrixID;
	id execMatrixID;
	id calendarID;		// The CalendarView object
	id clockID;			// The ClockView object

	/* Query Panel outlets */
	id queryPanelID;		// A Panel used to display the status of server queries
	id hostnameID;		// Hostname TextFieldCell
	id statusID;			// Status TextFieldCell
	id queryTimerID;	// A ClockView object to display query status
	id abortID;			// The abort button

	/* Help Panel outlets */
	id helpPanelID;		// The help panel
	id helpScrollViewID;	// The ScrollView in the help panel

	/* Ftp stuff */
	id ftpObject;			// The FTPManager object which handles ftp transfer
	id modeMatrixID;	// The file transfer mode Matrix
	id retrieveBtnID;		// The Retrieve Button in the main window
	id selectedFile;		// The ProsperoVLINK object of the file selected in the browser

	/* Other variables */
	cthread_t queryThread;	// The thread that performs the archie query
	VLINK archieRslt;		// The list of virtual links returned by archie_query()
	id hostHashTable;		// A HashTable that uses hostnames as entry keys
	id hostList;				// A List which stores the host files
	id errStringTable;		// An NXStringTable of the program error messages
	id infoPanelID;			// The application info Panel
	id selectionList;		// A List of the ProsperoVLINKs selected in the browser
	BOOL abortEnabled;
	const char *sendTypes[2];
}

/* Bring up the info panel */
- infoPanel: sender;

/* Display the query options panel */
- preferences: sender;

/* Bring up help info */
- showHelpFile: sender;

/* Methods which set the query options */
- setQueryType: sender;
- setExactMode: sender;
- setMaxReplies: sender;
- setOffset: sender;
- setSortType: sender;
- setNiceLevel: sender;
- setHostname: sender;
- setCustomHost: sender;
- setDebugLevel: sender;
- setAllowHide: sender;

/* Archie server request method */
- archieRequest: sender;		// Query the archive server
- interruptRequest: sender;	// Abort a query

/* Parsing and displaying the Archie server response */
- parseResponse: (VLINK) response;
- fileAttributes: sender;
- (BOOL) addSelectedCell: cell;
- clearFields;

/* Ftp methods */
- retrieveFile: sender;  // Retrieve the file selected in the browser via anonymous ftp
- setTransferDir: sender;	// Set the local host's receipt directory

/* Read/Restore default preferences */
- saveDefaults: sender;
- restoreDefaults: sender;

/* Clean up proceedure that send a kill(0, SIGQUIT) to try to make
	sure that no ftp processes are left */
- appWillTerminate: sender;
/* Make sure the main window is on screen */
- appDidUnhide: sender;

/* Access GatorFTP+ to initiate an anonymous ftp session via
	the services menu when a host is selected in the browser */
- validRequestorForSendType:(NXAtom)typeSent
	andReturnType:(NXAtom)typeReturned;

/* Write the currently selected hostname to the pasteboard */
- (BOOL)writeSelectionToPasteboard:pboard types:(NXAtom *)types;

/* Error handling */
- error:(int) severity key:(const char *) keyString;

@end
/* RCS Information:
	$Author: me $;
	$Date: 92/05/03 17:24:33 $;
	$Source: /RS6000/usr/local/NFS_NeXT/Dev/Net/Archie_Prospero/Archie/RCS/ArchieServer.h,v $;
	$Revision: 1.4 $;
*/
