/* #########################################################################

			       XCORAL SMAC

   File: save-ext.sc

   Created: Tue Nov 30 19:02:35 1993
   Author: Thierry Emery
   Modified: Fri Jan 21 16:26:49 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: save file utilities
   
   Requires: comments.sc

   Defines: update_title_and_save_file, update_title_backup_and_save_file

   Suggested bindings: "^xz" "update_title_and_save_file"
		       "^xs" "update_title_backup_and_save_file"

   Procedure: - to update the `File', `Path', `Modified' and
		`Last maintained by' fields, and save the file, execute
		`update_title_and_save_file'
	      - to do the same, but move old version to <filename>~ first,
		execute `update_title_backup_and_save_file'

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   update title and save file
   ------------------------------------------------------------------------- */

void update_title_and_save_file() {

  char* file_name=filename();

  if (file_name) {
    update_title();
    save_file();
    free(file_name);
  }
  else {
    file_name = gets("Write file :");
    if (file_name) {
      write_file(file_name);
      update_title();
      save_file();
      free(file_name);
    }
  }
}

/* -------------------------------------------------------------------------
   update title, remove old backup ('<filename>~') with "rm -f",
   make new backup with "cp -p" and finally save file
   ------------------------------------------------------------------------- */

void update_title_backup_and_save_file() {

  char *file_name=filename(), *rm_command, *cp_command;

  if (file_name) {
    rm_command = (char*) malloc(strlen(file_name)+8);
    sprintf(rm_command,"rm -f %s~",file_name);

    cp_command = (char*) malloc(2*strlen(file_name)+9);
    sprintf(cp_command,"cp -p %s %s~",file_name,file_name);

    cmd_shell(rm_command);
    cmd_shell(cp_command);
    update_title();
    save_file();

    free(rm_command);
    free(cp_command);
    free(file_name);
  }
  else {
    file_name = gets("Write file :");
    if (file_name) {
      write_file(file_name);
      update_title();
      save_file();
      free(file_name);
    }
  }
}

