/* #########################################################################

			       XCORAL SMAC

   File: rcs-commands.sc
   Created: Mon Jan 3 17:31:08 1994
   Author: Thierry Emery
   Modified: Mon Feb 21 10:20:49 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.6 $ $State: Exp $

   #########################################################################

   Note: SMAC interface for RCS (ci, co, rlog, rcsdiff)

   Defines: CheckIn, CheckInAndOut, CheckOut, Rlog, RcsDiff

   Suggested bindings: "^x^i" "CheckIn"
		       "^x^a" "CheckInAndOut"
		       "^x^o" "CheckOut"
		       "^x^l" "Rlog"
		       "^x^d" "RcsDiff"

   Procedure: From each file's window, CheckIn once, then alternate CheckOut
	      and CheckIn, or repeat CheckInAndOut ... (see ci & co in man)

	      If you modify a buffer whose file is not checked out, you will
	      get a `Permission denied' message if you attempt to save it.
	      You can then check it out (execute `CheckOut' from its window)
	      and save it.

	      To print the RCS log for the current file, execute `Rlog'

	      To compare the current file to an existing revision, execute
	      `RcsDiff'

   Warnings: - Initial description is not handled yet (and is even deleted
	       by CheckIn and CheckInAndOut)
	     - Executing CheckOut on a checked out file freezes Xcoral; you
	       then have to kill the process executing the `co' command
	       (should be tested in a future revision of this interface)

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   Try to determine comment leader (redefinable)
   ------------------------------------------------------------------------- */

char* check_in_comment_leader() {

    if (the_char(0) == '/' && the_char(1) == '*')
      return "   ";
    else
      return "# ";
}

/* -------------------------------------------------------------------------
   Does the work for CheckIn and CheckInAndOut : checks in an RCS file and
   checks it back out locked or unlocked.
   Cancelling the log message cancels checking in the file.
   ------------------------------------------------------------------------- */

void check_in_internal(int lock_p) {
  
  char *ci_command, *file, *comment_leader, *log_msg, *lock_switch;
  int  origin_window=current_window();
  
  file = filename();
  
  if (file) {
    save_file();
    log_msg = gets("Log message : ");
    lock_switch = (lock_p ? "-l" : "");
    comment_leader = check_in_comment_leader();
    
    if (!gets_string_cancelled(log_msg)) {
	ci_command = (char*) malloc(3*strlen(file)+strlen(comment_leader)
				    +strlen(lock_switch)+strlen(log_msg)+60);
      sprintf(ci_command,"ci -t-\"\" -m\"%s\" %s 2>&1; rcs -c\"%s\" %s 2>&1; co %s %s 2>&1",
	      log_msg,file,comment_leader,file,lock_switch,file);
      cmd(ci_command);
      free(ci_command);
      
      select_window(origin_window);
      read_file(file);
    }
    else
      display_message("Check in cancelled","Information",1);
    
    if (log_msg)
      free(log_msg);
    
    free(file);
  }
}

/* -------------------------------------------------------------------------
   Checks in an RCS file and checks it back out unlocked (read-only)
   ------------------------------------------------------------------------- */

void CheckIn() {

  check_in_internal(0);
}

/* -------------------------------------------------------------------------
   Checks in an RCS file and checks it back out locked (read-write)
   ------------------------------------------------------------------------- */

void CheckInAndOut() {

  check_in_internal(1);
}

/* -------------------------------------------------------------------------
   Check an RCS file out locked (read-write) for user
   ------------------------------------------------------------------------- */

void CheckOut() {

  char *co_command, *file;
  int  not_checked_out=0;
  int origin_win=current_window();

  file = filename();

  if (!file) {
    file = gets("Check out file : ");
    if (gets_string_cancelled(file)) {
      free(file);
      file = 0;
    }
    else
      not_checked_out=1;
  }

  if (file) {
    co_command = (char*) malloc(strlen(file)+7);
    sprintf(co_command,"co -l %s",file);
    cmd(co_command);
    free(co_command);
    select_window(origin_win);
    if (not_checked_out)
      read_file(file);
    free(file);
  }
}

/* -------------------------------------------------------------------------
   print RCS log for current file
   ------------------------------------------------------------------------- */

void Rlog() {

  char *log_command, *file;

  file = filename();

  if (file) {
    log_command = (char*) malloc(strlen(file)+6);
    sprintf(log_command,"rlog %s",file);
    free(file);
    cmd(log_command);
    free(log_command);
  }
}

/* -------------------------------------------------------------------------
   Does an RCS diff for current file
   ------------------------------------------------------------------------- */

void RcsDiff() {

  char *diff_command, *file, *revision;

  file = filename();

  if (file) {
    revision = gets("rcs diff with revision : ");

    if (!gets_string_cancelled(revision)) {
      diff_command = (char*) malloc(strlen(revision)+strlen(file)+13);
      sprintf(diff_command,"rcsdiff -r%s %s",revision,file);
      cmd(diff_command);
      free(diff_command);
    }

    if (revision)
      free(revision);
    free(file);
  }
}

