/* #########################################################################

			       XCORAL SMAC

   File: basics.sc
   Created: Mon Jan 3 16:31:16 1994
   Author: Thierry Emery
   Modified: Fri Jan 21 16:19:21 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.3 $ $State: Exp $

   #########################################################################

   Note: basic functions for SMAC programmers

   Defines: read_int_from_string, gets_string_cancelled

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   reads an int from a string
   ------------------------------------------------------------------------- */

int read_int_from_string(char* str) {

  int index=0, result=0, negative_p=0;
  char c;

  for (; index<strlen(str); ++index) {
    c = str[index];
    if (c != ' ' && c != '\t')
      break;
  }

  if (str[index] == '-') {
    negative_p = 1;
    ++index;
  }

  for (; index<strlen(str); ++index) {
    c = str[index];
    if (c >= '0' && c <= '9') {
      result *= 10;
      result += (c - '0');
    }
    else
      break;
  }

  if (negative_p)
    return -result;
  else
    return result;
}

/* -------------------------------------------------------------------------
   checks that a string returned by gets is valid (not empty and not cancelled)
   ------------------------------------------------------------------------- */

int gets_string_cancelled(char* str) {

  return (!str || strlen(str) == 0
	  || (strlen(str) == 1 && str[0] == ((char) 7)));
}

