/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef  _WARN_BOX_H_
#define  _WARN_BOX_H_

#include "proto_decl.h"

#define BOX_FONT "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1"
#define TITLE_SIZE 128

#define WB_SPACE 10
#define WB_MAP    1
#define WB_UNMAP  2

#define WB_SAVE "Save"
#define WB_CLOSE "Close"
#define WB_FROM "From : "

#define GetWarningBoxFrame() (w_box.frame)

typedef struct {
	Window		frame, title, main, ctr, save, close;
	unsigned long 	fg, bg, ts, bs;
	GC		gc;
	XFontStruct 	*font;
	int		height, width, b_width, b_height;
	int             t_height, t_width;
	int             str_x, str_y;
	char            title_text [TITLE_SIZE];
	Text            *text;
	SWin            *scroll;
	Buf             *buf;
	MWin            *mwin;
	int             stat;
} WBox;

FCT (int, ButtonWarningBox, (XButtonEvent *ev) );
FCT (void, ConfigWarningBox, (int width, int height) );
FCT (void, DisplayWMessage, (char *mess, char *from, int separator) );
FCT (int, ExposeWarningBox , (XEvent *ev) );
FCT (void, InitWarningBox, () );
FCT (void, UnmapWarningBox, () );

#endif /* _WARN_BOX_H_ */
