/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _TEXT_CURSOR_H_
#define _TEXT_CURSOR_H_

#include "proto_decl.h"

FCT (void, BackwardChar, (Text *text) );
FCT (void, DownCursor, (Text *text) );
FCT (int, ForwardChar, (Text *text) );
FCT (void, FreezeTextCursor, (Text *text) );
FCT (void, GotoLeft, (Text *text) );
FCT (char *, HscrollString, (char *s, Text *text) );
FCT (void, MoveToBline, (Text *text) );
FCT (void, MoveToEline, (Text *text) );
FCT (int, MoveToXYinTextWindow, (Text *text, int x, int y) );
FCT (void, TextCursorOn, (Text *text) );
FCT (void, TextCursorOff, (Text *text) );
FCT (void, UnFreezeTextCursor, (Text *text) );
FCT (void, UpCursor, (Text *text) );

#endif /* _TEXT_CURSOR_H_ */
