/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _SCROLL_H_
#define _SCROLL_H_

#include "proto_decl.h"

#define SCROLL_WIDTH 16
#define DEFAULT_SIZE 10

#define UP 0
#define DOWN 1
#define TOP 2
#define BOTTOM 3
#define OTHER 4
#define FIRST 5
#define LAST 6
#define NEXT 7
#define PREVIOUS 8
#define CURRENT 9
#define CURSOR 10

typedef struct {
	Window	frame;		/* Main window */
	Window	scroll;		/* Le curseur */
	unsigned long fg, bg;	/* Les couleurs */
	int width;		/* Largeur totale */
	int f_height;		/* geometrie frame et scroll */
	int s_height;
	int fx, fy, sx, sy;	
	XFontStruct *font;	/* La fonte utilisee pour le texte a scroller */
	int line;		/* Infos sur le nb de lignes a scroller */
	int linepage;  		
	int line_to_scroll;
	double	delta;		/* Pour les calculs */
	int y_min, y_max;    
	int last_dir;		/* Derniere direction pour la scrollbar */
	int last_y;     		  	
	double	rest;		/* La fraction de ligne restant a scroller */
	char	*text;		/* Vers les infos sur le texte */
} SWin;

FCT (int, ButtonPressInScroll, (SWin *swin, Window w, int y, int *result) );
FCT (void, DeleteScroll, (Display *display, SWin *swin) );
FCT (int, ExposeInScroll, (Display *display, Window w, SWin *swin) );
FCT (void, HandleScrollBar, (Display *display, SWin *swin, void (*f)()) );
FCT (void, InitScroll, (Display *display) );
FCT (SWin *, MakeScroll, (Display *display, Window parent, int x, int y) );
FCT (int, MoveScrollBar, (Display *display, SWin *swin, int flag, int dy) );
FCT (void, RefreshScroll, (Display *display, SWin *swin, int width, int height, int n) );
FCT (void, RefreshScrollBar, (Display *display, SWin *s) );
FCT (void, RefreshScrollFrame, (Display *display, SWin *s) );
FCT (void, SetScrollBarSize, (Display *display, SWin *swin) );
FCT (void, SetScrollLine, (SWin *swin, int n) );
FCT (void, ShowScrollFrame, (Display *display, SWin *s) );

#define SetScrollFont(s, f)	(s -> font = f)
#define SetScrollLinePage(s, n)	(s -> linepage = n)
#define GetScrollWidth()	(SCROLL_WIDTH)

#endif /* _SCROLL_H_ */

