/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _PAGE_H_
#define _PAGE_H_

#include "proto_decl.h"

FCT (void, AtLineDisplayPage, (Text *text, int line) );
FCT (void, ClearLine, (Text *text, int i) );
FCT (void, ClearPage, (Text *text) );
FCT (void, ClipOff, (Text *text) );
FCT (void, ClipOn, (Text *text, int line) );
FCT (void, CurrentLineToMiddle, (Text *text) );
FCT (void, CurrentLineToTop, (Text *text) );
FCT (void, CurrentLineToTopFromMenu, (Text *text) );
FCT (char *, CurrentTextItem, (Text *text) );
FCT (void, ExposePage, (Region r, Text *text) );
FCT (void, FirstPage, (Text *text) );
FCT (void, FirstPageAndUpdateScroll, (Text *text) );
FCT (void, GotoEndOfBuf, (Text *text) );
FCT (void, GotoLineNumber, (Text *text, int n) );
FCT (void, LastPage, (Text *text) );
FCT (void, NextPage, (Text *text) );
FCT (void, PreviousPage, (Text *text) );
FCT (void, RefreshPage, (Text *text) );
FCT (void, RefreshPageAndUpdateScroll, (Text *text) );
FCT (void, RunScroll, (Text *text, int result) );
FCT (void, RunScrollAndUpdateItem, (Text *text, int select, int s_type) );
FCT (void, ScrollDownCont, (Text *text) );
FCT (void, ScrollUpCont, (Text *text) );
FCT (void, ScrollNLine, (int n, Text *text) );
FCT (int, SelectTextItem, (Text *text, int x, int y, int select) );
FCT (void, SetAndDisplayPage, (Text *text) );
FCT (void, SetCurrentLine, (Text *text) );
FCT (void, SetLinesTable, (Text *text) );
FCT (void, SetPosition, (Text *text) );
FCT (void, StorePosition, (Text *text) );
FCT (void, UpdatePage, (Text *text) );
FCT (void, UpdateTextItem, (Text *text, int n) );
FCT (void, WatchOff, (Window win) );
FCT (void, WatchOn, (Window win) );
FCT (void, klaxon, () );

#endif /* _PAGE_H_ */
