/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef  _MODE_H_
#define  _MODE_H_

#include "proto_decl.h"

typedef struct {
    void (* func) (); /* La fonction associee a la clef */
    int type;         /* Fonction de l'editeur ou de l'utilisateur */
} MK;
  
/*
 *  Les mot cles du mode.
 */   
typedef struct kw {
    char kw_name [32];
    int kw_len;
    struct kw *next;
} KW;

/*
 * Le Mode
 */
typedef struct _mode {
    char *name;
    char *suffixes;
    KW *keywords;
    unsigned long keyword_color;
    XFontStruct *font;
    MK key [512];
    MK ctrX_key [512];
    MK esc_key [512];
    struct _mode *next;
} Mode;

FCT (Mode *, CreateNewMode, (char *mode_name) );
FCT (int, GetFuncNameFromString, (char *s) );
FCT (Mode *, GetMode, (char *name) );
FCT (void, InitMode, () );
FCT (Mode *, SearchMode, (char *filename) );
FCT (void, SetModeFont, (Mode *mode, char *font_name) );
FCT (void, SetModeSuffixe, (Mode *mode, char *suffixes) );
FCT (void, SetKeywordColor, (Mode *mode, char *color) );
FCT (void, AddKeyword, (Mode *mode, char *name) );
FCT (void, RemoveKeywordColor, (Mode *mode) );

#endif /* _MODE_H_ */
