/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef  _MAN_BOX_H_
#define  _MAN_BOX_H_

#include "proto_decl.h"

#define BOX_FONT "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1"

#define TITLE_SIZE 128

#define MB_BUFFER_SIZE	10000
#define MB_SPACE  10
#define MB_MAP    1
#define MB_UNMAP  2
#define MB_TITLE "This is the man"
#define MB_MANTITLE "Manual page"
#define MB_INDEXTITLE "Index"
#define MB_TOCTITLE "Table of contents"
#define MB_SEARCH "Search"
#define MB_CLOSE "Close"
#define MB_UP "Up"
#define MB_DOWN "Down"

typedef struct {

  Window frame, title, ctr, close, search, up, down;
  Window manframe, indexframe, tocframe;
  Window mantitle, indextitle, toctitle;
  Window mantext, indextext, toctext;
  unsigned long fg, bg, ts, bs, text_fg, text_bg;
  XFontStruct	*font;
  GC gc;
  int	width, height, t_height, b_width, b_height;
  int str_x, str_y;
  Text *man_text, *index_text, *toc_text;
  char title_text [TITLE_SIZE];
  Buf *man_buf, *index_buf, *toc_buf;
  MWin *mwin;
  SWin *man_scroll, *index_scroll, *toc_scroll;
  int select_index, select_toc;
  int	m_width, m_height;
  Time click_time;
  Time old_click;
  int stat;
  int empty;
  int width_text;
  
} MBox;

FCT (int, ButtonManBox, ( XButtonEvent * ev ));
FCT (void, ConfigManBox, (int width, int height) );
FCT (void, DisplayManBox, () );
FCT (int, ExposeManBox, (XEvent *ev) );
FCT (void, InitManBox, () );
FCT (int, KeyPressInManual, (XKeyEvent * ev ));
    
#define GetManBoxFrame() (man_box.frame)

#endif /* _MAN_BOX_H_ */
